/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.metrics;

import io.dropwizard.metrics5.Gauge;
import io.dropwizard.metrics5.Metric;
import io.dropwizard.metrics5.MetricName;
import io.dropwizard.metrics5.MetricSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public class NuxeoMetricSet
implements MetricSet {
    protected final Map<MetricName, Metric> metrics;
    protected final MetricName prefixName;

    public NuxeoMetricSet() {
        this(null);
    }

    public NuxeoMetricSet(String name, String ... names) {
        this(MetricName.build((String[])new String[]{name}).append(MetricName.build((String[])names)));
    }

    public NuxeoMetricSet(MetricName name) {
        this(HashMap::new, name);
    }

    public NuxeoMetricSet(Supplier<Map<MetricName, Metric>> metricsSupplier, MetricName name) {
        this.metrics = metricsSupplier.get();
        this.prefixName = name;
    }

    public <T> void putGauge(Gauge<T> gauge, MetricName name) {
        this.metrics.put(this.prefixName.append(name), (Metric)gauge);
    }

    public <T> void putGauge(Gauge<T> gauge, String name, String ... names) {
        this.metrics.put(this.prefixName.append(MetricName.build((String[])new String[]{name}).append(MetricName.build((String[])names))), (Metric)gauge);
    }

    public Map<MetricName, Metric> getMetrics() {
        return this.metrics;
    }

    public MetricName getPrefixName() {
        return this.prefixName;
    }

    public Set<MetricName> getMetricNames() {
        return this.metrics.keySet();
    }
}

