/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.metrics.reporter;

import io.dropwizard.metrics5.MetricAttribute;
import io.dropwizard.metrics5.MetricFilter;
import io.dropwizard.metrics5.MetricRegistry;
import io.opencensus.contrib.dropwizard5.DropWizardMetrics;
import io.opencensus.exporter.stats.prometheus.PrometheusStatsCollector;
import io.opencensus.metrics.Metrics;
import io.opencensus.metrics.export.MetricProducer;
import io.prometheus.client.exporter.HTTPServer;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.runtime.metrics.AbstractMetricsReporter;

public class PrometheusReporter
extends AbstractMetricsReporter {
    private static final Logger log = LogManager.getLogger(PrometheusReporter.class);
    protected static final int DEFAULT_PORT = 9090;
    protected int port;
    protected int zPort;
    protected HTTPServer server;

    @Override
    public void init(long pollInterval, Map<String, String> options) {
        super.init(pollInterval, options);
        this.port = this.getOptionAsInt("port", 9090);
    }

    @Override
    public void start(MetricRegistry registry, MetricFilter filter, Set<MetricAttribute> deniedExpansions) {
        log.warn("Creating Prometheus endpoint on port {}", (Object)this.port);
        DropWizardMetrics registries = new DropWizardMetrics(Collections.singletonList(registry), filter);
        Metrics.getExportComponent().getMetricProducerManager().add((MetricProducer)registries);
        try {
            PrometheusStatsCollector.createAndRegister();
        }
        catch (IllegalArgumentException e) {
            log.warn("Prometheus collector already registered");
        }
        try {
            this.server = new HTTPServer(this.port, true);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot start Prometheus on port " + this.port, e);
        }
    }

    @Override
    public void stop() {
        log.debug("Stop reporting");
        this.server.stop();
        this.server = null;
    }
}

