/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.metrics.reporter;

import io.dropwizard.metrics5.MetricAttribute;
import io.dropwizard.metrics5.MetricFilter;
import io.dropwizard.metrics5.MetricRegistry;
import io.opencensus.common.Duration;
import io.opencensus.contrib.dropwizard5.DropWizardMetrics;
import io.opencensus.exporter.stats.stackdriver.StackdriverStatsConfiguration;
import io.opencensus.exporter.stats.stackdriver.StackdriverStatsExporter;
import io.opencensus.metrics.Metrics;
import io.opencensus.metrics.export.MetricProducer;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.utils.DurationUtils;
import org.nuxeo.runtime.metrics.AbstractMetricsReporter;
import org.nuxeo.runtime.metrics.reporter.StackdriverTraceReporter;

public class StackdriverReporter
extends AbstractMetricsReporter {
    private static final Logger log = LogManager.getLogger(StackdriverReporter.class);
    protected static final String PREFIX_OPTION = "prefix";
    protected static final String DEFAULT_PREFIX = "custom.googleapis.com/nuxeo/";
    protected boolean activated;

    @Override
    public void start(MetricRegistry registry, MetricFilter filter, Set<MetricAttribute> deniedExpansions) {
        log.warn("Creating Stackdriver metrics reporter");
        DropWizardMetrics registries = new DropWizardMetrics(Collections.singletonList(registry), filter);
        Metrics.getExportComponent().getMetricProducerManager().add((MetricProducer)registries);
        Duration timeout = Duration.create((long)DurationUtils.parsePositive((String)((String)this.options.get("timeout")), (java.time.Duration)DEFAULT_TIMEOUT).getSeconds(), (int)0);
        String projectId = StackdriverTraceReporter.getGcpProjectId(this.options);
        String prefix = this.options.getOrDefault(PREFIX_OPTION, DEFAULT_PREFIX);
        Duration interval = Duration.fromMillis((long)(this.getPollInterval() * 1000L));
        StackdriverStatsConfiguration configuration = StackdriverStatsConfiguration.builder().setDeadline(timeout).setProjectId(projectId).setMetricNamePrefix(prefix).setExportInterval(interval).build();
        try {
            StackdriverStatsExporter.createAndRegister((StackdriverStatsConfiguration)configuration);
        }
        catch (IOException e) {
            log.error("Fail to create a Stackdriver metric reporter", (Throwable)e);
            return;
        }
        this.activated = true;
    }

    @Override
    public void stop() {
        log.debug("Stop reporting");
        if (this.activated) {
            StackdriverStatsExporter.unregister();
            this.activated = false;
        }
    }
}

