/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.mongodb;

import com.mongodb.MongoClient;
import com.mongodb.client.MongoDatabase;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.mongodb.MongoDBConnectionConfig;
import org.nuxeo.runtime.mongodb.MongoDBConnectionHelper;
import org.nuxeo.runtime.mongodb.MongoDBConnectionService;

public class MongoDBComponent
extends DefaultComponent
implements MongoDBConnectionService {
    public static final String COMPONENT_NAME = "org.nuxeo.runtime.mongodb.MongoDBComponent";
    private static final String XP_CONNECTION = "connection";
    private static final String DEFAULT_CONNECTION_ID = "default";
    private final Map<String, MongoClient> clients = new ConcurrentHashMap<String, MongoClient>();

    protected String getName() {
        return COMPONENT_NAME;
    }

    public void start(ComponentContext context) {
        super.start(context);
        List confs = this.getDescriptors(XP_CONNECTION);
        confs.forEach(c -> {
            this.getLog().debug((Object)("Initializing MongoClient with id=" + c.getId()));
            this.clients.put(c.getId(), MongoDBConnectionHelper.newMongoClient(c.server));
        });
    }

    public void stop(ComponentContext context) throws InterruptedException {
        super.stop(context);
        this.clients.entrySet().forEach(e -> {
            this.getLog().debug((Object)("Closing MongoClient with id=" + (String)e.getKey()));
            ((MongoClient)e.getValue()).close();
        });
        this.clients.clear();
    }

    public int getApplicationStartedOrder() {
        return 99;
    }

    @Override
    public MongoDatabase getDatabase(String id) {
        MongoDBConnectionConfig config = (MongoDBConnectionConfig)this.getDescriptor(XP_CONNECTION, id);
        MongoClient client = this.clients.get(id);
        if (client == null) {
            config = (MongoDBConnectionConfig)this.getDescriptor(XP_CONNECTION, DEFAULT_CONNECTION_ID);
            client = this.clients.get(DEFAULT_CONNECTION_ID);
        }
        return MongoDBConnectionHelper.getDatabase(client, config.dbname);
    }

    @Override
    public Iterable<MongoDatabase> getDatabases() {
        return () -> this.clients.entrySet().stream().map(e -> {
            MongoDBConnectionConfig c = (MongoDBConnectionConfig)this.getDescriptor(XP_CONNECTION, (String)e.getKey());
            return MongoDBConnectionHelper.getDatabase((MongoClient)e.getValue(), c.dbname);
        }).iterator();
    }
}

