/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.osgi.application.loader;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.nuxeo.common.Environment;
import org.nuxeo.osgi.BundleFile;
import org.nuxeo.osgi.DirectoryBundleFile;
import org.nuxeo.osgi.JarBundleFile;
import org.nuxeo.osgi.SystemBundle;
import org.nuxeo.osgi.application.SharedClassLoader;
import org.nuxeo.osgi.application.loader.StandaloneApplication2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Loader {
    public static Environment createEnvironment() throws IOException {
        return Loader.createEnvironment(null);
    }

    public static Environment createEnvironment(Properties props) throws IOException {
        if (props != null) {
            String[] args;
            String val = (String)props.get("org.nuxeo.app.home");
            if (val == null && (val = System.getProperty("org.nuxeo.app.home")) == null) {
                val = ".";
            }
            File home = new File(val);
            home = home.getCanonicalFile();
            Environment env = new Environment(home, props);
            val = (String)props.get("org.nuxeo.app.system_bundle");
            if (val != null) {
                env.setProperty("org.nuxeo.app.system_bundle", val);
            }
            if ((args = (String[])props.get("org.nuxeo.app.args")) != null) {
                env.setCommandLineArguments(args);
            } else {
                env.setCommandLineArguments(new String[0]);
            }
            val = (String)props.get("org.nuxeo.app.data");
            if (val != null) {
                env.setData(new File(val).getCanonicalFile());
            }
            if ((val = (String)props.get("org.nuxeo.app.log")) != null) {
                env.setLog(new File(val).getCanonicalFile());
            }
            if ((val = (String)props.get("org.nuxeo.app.config")) != null) {
                env.setConfig(new File(val).getCanonicalFile());
            }
            if ((val = (String)props.get("org.nuxeo.app.web")) != null) {
                env.setWeb(new File(val).getCanonicalFile());
            }
            if ((val = (String)props.get("org.nuxeo.app.tmp")) != null) {
                env.setTemp(new File(val).getCanonicalFile());
            }
            if ((val = (String)props.get("bundles")) != null) {
                env.setProperty("nuxeo.osgi.bundles", val);
            }
            if ((val = (String)props.get("org.nuxeo.app.tmp")) != null) {
                env.setHostApplicationName(val);
            } else {
                env.setHostApplicationName("NXLauncher");
            }
            val = (String)props.get("org.nuxeo.app.tmp");
            if (val != null) {
                env.setHostApplicationVersion(val);
            } else {
                env.setHostApplicationVersion("1.0.0");
            }
            env.getData().mkdirs();
            env.getLog().mkdirs();
            env.getTemp().mkdirs();
            return env;
        }
        return new Environment(new File("").getCanonicalFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadFramework(SharedClassLoader cl, File systemBundle, List<File> classPath, Properties properties) throws Exception {
        StandaloneApplication2 app;
        long startTime = System.currentTimeMillis();
        Environment env = Loader.createEnvironment(properties);
        Environment.setDefault((Environment)env);
        String[] args = env.getCommandLineArguments();
        StandaloneApplication2.instance = app = new StandaloneApplication2(cl, env);
        if (args != null) {
            if (Loader.hasArgument(args, "-scanForNestedJars")) {
                app.setScanForNestedJARs(true);
            }
            if (Loader.hasArgument(args, "-clear")) {
                app.setFlushCache(true);
            }
        }
        File home = env.getHome();
        app.setClassPath(classPath);
        String sb = env.getProperty("org.nuxeo.app.system_bundle");
        if (sb == null) {
            throw new IllegalStateException("Property systemBundle was not set");
        }
        System.out.println("======================================================================");
        System.out.println("= Starting Nuxeo Framework");
        System.out.println("======================================================================");
        System.out.println("  * Home Directory = " + home);
        System.out.println("  * Data Directory = " + env.getData());
        System.out.println("  * Log Directory = " + env.getLog());
        System.out.println("  * Configuration Directory = " + env.getConfig());
        System.out.println("  * Temp Directory = " + env.getTemp());
        System.out.println("  * System Bundle = " + systemBundle);
        System.out.println("  * Command Line Args = " + Arrays.asList(env.getCommandLineArguments()));
        System.out.println("======================================================================");
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(cl);
            app.setSystemBundle(new SystemBundle(app, Loader.createSystemBundle(systemBundle), cl));
            app.start();
            System.out.println("Framework started in " + (System.currentTimeMillis() - startTime) / 1000L + " sec.");
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    public static void shutdown() {
        if (StandaloneApplication2.instance != null) {
            try {
                StandaloneApplication2.instance.shutdown();
                StandaloneApplication2.instance = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean hasArgument(String[] args, String arg) {
        if (args != null) {
            for (String el : args) {
                if (!el.equals(arg)) continue;
                return true;
            }
        }
        return false;
    }

    public static File newFile(File home, String path) throws IOException {
        if (path.startsWith("/")) {
            return new File(path).getCanonicalFile();
        }
        return new File(home, path).getCanonicalFile();
    }

    public static List<File> buildClassPath(SharedClassLoader classLoader, File home, String rawcp) {
        ArrayList<File> result = new ArrayList<File>();
        try {
            String[] cp;
            for (String entry : cp = rawcp.split(":")) {
                File entryFile;
                if (entry.endsWith("/.")) {
                    entryFile = Loader.newFile(home, entry.substring(0, entry.length() - 2));
                    File[] files = entryFile.listFiles();
                    if (files == null) continue;
                    for (File file : files) {
                        result.add(file);
                        classLoader.addURL(file.toURI().toURL());
                    }
                    continue;
                }
                entryFile = Loader.newFile(home, entry);
                result.add(entryFile);
                classLoader.addURL(entryFile.toURI().toURL());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        return result;
    }

    public static BundleFile createSystemBundle(File file) throws IOException {
        BundleFile sysbf = file.isFile() ? new JarBundleFile(file) : new DirectoryBundleFile(file);
        return sysbf;
    }
}

