/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.osgi.application.loader;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.nuxeo.common.Environment;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.osgi.BundleFile;
import org.nuxeo.osgi.BundleImpl;
import org.nuxeo.osgi.DirectoryBundleFile;
import org.nuxeo.osgi.JarBundleFile;
import org.nuxeo.osgi.OSGiAdapter;
import org.nuxeo.osgi.application.ClassPath;
import org.nuxeo.osgi.application.SharedClassLoader;
import org.nuxeo.osgi.application.StandaloneApplication;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandaloneApplication2
extends OSGiAdapter {
    public static final String MAIN_TASK = "org.nuxeo.osgi.application.main.task";
    static StandaloneApplication2 instance;
    private static Runnable mainTask;
    protected final SharedClassLoader classLoader;
    protected final Environment env;
    protected boolean isStarted;
    protected File home;
    protected List<File> classPath;
    protected boolean scanForNestedJARs = true;
    protected boolean flushCache = false;

    public static StandaloneApplication2 getInstance() {
        return instance;
    }

    public static StandaloneApplication2 createInstance(SharedClassLoader cl) throws IOException {
        if (instance != null) {
            throw new IllegalStateException("Application already instantiated");
        }
        Environment env = StandaloneApplication2.createEnvironment();
        Environment.setDefault((Environment)env);
        instance = new StandaloneApplication2(cl, env);
        return instance;
    }

    public StandaloneApplication2(SharedClassLoader cl, Environment env) {
        super(env.getHome(), env.getData(), env.getProperties());
        this.classLoader = cl;
        this.env = env;
    }

    public void setScanForNestedJARs(boolean value) {
        this.scanForNestedJARs = value;
    }

    public void setFlushCache(boolean flushCache) {
        this.flushCache = flushCache;
    }

    public boolean isScanForNestedJARs() {
        return this.scanForNestedJARs;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Environment getEnvironment() {
        return this.env;
    }

    public void start() throws Exception {
        if (this.isStarted) {
            throw new IllegalStateException("OSGi Application is already started");
        }
        this.startBundles();
        this.autoInstallBundles();
        this.fireFrameworkEvent(new FrameworkEvent(1, this.getSystemBundle(), null));
        if (mainTask != null) {
            mainTask.run();
        } else {
            Field f = StandaloneApplication.class.getDeclaredField("mainTask");
            f.setAccessible(true);
            mainTask = (Runnable)f.get(null);
            if (mainTask != null) {
                mainTask.run();
            }
        }
        this.isStarted = true;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() throws IOException {
        if (!this.isStarted) {
            throw new IllegalStateException("OSGi Application was not started");
        }
        try {
            super.shutdown();
        }
        finally {
            this.isStarted = false;
        }
    }

    protected void startBundles() throws Exception {
        String[] ar;
        String bundlesString = this.env.getProperty("nuxeo.osgi.bundles");
        if (bundlesString == null) {
            return;
        }
        ArrayList bundles = new ArrayList();
        for (String entry : ar = StringUtils.split((String)bundlesString, (char)',', (boolean)true)) {
            File file;
            if (entry.contains("file:")) {
                URL url = new URL(entry);
                file = new File(url.toURI());
            } else {
                file = new File(entry);
            }
            BundleFile bf = file.isDirectory() ? new DirectoryBundleFile(file) : new JarBundleFile(file);
            this.classLoader.addURL(bf.getURL());
        }
        for (BundleFile bf : bundles) {
            this.install(new BundleImpl(this, bf, this.classLoader));
        }
    }

    public List<File> getClassPath() {
        return this.classPath;
    }

    public void setClassPath(List<File> classPath) {
        this.classPath = classPath;
    }

    protected void autoInstallBundles() throws Exception {
        List<File> cp = this.getClassPath();
        if (cp == null || cp.isEmpty()) {
            return;
        }
        ClassPath cpath = new ClassPath(this.classLoader, new File(this.env.getData(), "nested-jars"));
        File cache = new File(this.env.getData(), "bundles.cache");
        if (!this.flushCache && cache.exists()) {
            try {
                cpath.restore(cache);
            }
            catch (BundleException e) {
                cpath.scan(this.classPath, this.scanForNestedJARs);
                cpath.store(cache);
            }
        } else {
            cpath.scan(this.classPath, this.scanForNestedJARs);
            cpath.store(cache);
        }
        this.installAll(cpath.getBundles());
    }

    public void install(BundleFile bf) throws BundleException {
        this.install(new BundleImpl(this, bf, this.classLoader));
    }

    public void installAll(List<BundleFile> bundles) throws BundleException {
        for (BundleFile bf : bundles) {
            this.install(new BundleImpl(this, bf, this.classLoader));
        }
    }

    public static Environment createEnvironment() throws IOException {
        return StandaloneApplication2.createEnvironment(null);
    }

    public static Environment createEnvironment(Properties props) throws IOException {
        if (props != null) {
            String val = (String)props.get("home");
            if (val == null && (val = System.getProperty("org.nuxeo.app.home")) == null) {
                val = ".";
            }
            File home = new File(val);
            home = home.getCanonicalFile();
            Environment env = new Environment(home);
            String[] args = (String[])props.get("org.nuxeo.app.args");
            if (args != null) {
                env.setCommandLineArguments(args);
            }
            if ((val = (String)props.get("org.nuxeo.app.data")) != null) {
                env.setData(new File(val).getCanonicalFile());
            }
            if ((val = (String)props.get("org.nuxeo.app.log")) != null) {
                env.setLog(new File(val).getCanonicalFile());
            }
            if ((val = (String)props.get("org.nuxeo.app.config")) != null) {
                env.setConfig(new File(val).getCanonicalFile());
            }
            if ((val = (String)props.get("org.nuxeo.app.web")) != null) {
                env.setWeb(new File(val).getCanonicalFile());
            }
            if ((val = (String)props.get("org.nuxeo.app.tmp")) != null) {
                env.setTemp(new File(val).getCanonicalFile());
            }
            if ((val = (String)props.get("bundles")) != null) {
                env.setProperty("nuxeo.osgi.bundles", val);
            }
            env.setHostApplicationName("NXLauncher");
            env.setHostApplicationVersion("1.0.0");
            env.getData().mkdirs();
            env.getLog().mkdirs();
            env.getTemp().mkdirs();
            return env;
        }
        return new Environment(new File("").getCanonicalFile());
    }

    public static void setMainTask(Runnable mainTask) {
        StandaloneApplication2.mainTask = mainTask;
    }
}

