/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.osgi.application;

import java.io.File;
import java.util.ArrayList;
import org.nuxeo.osgi.BundleFile;
import org.nuxeo.osgi.BundleImpl;
import org.nuxeo.osgi.OSGiAdapter;
import org.nuxeo.osgi.application.ApplicationLoader;
import org.nuxeo.osgi.application.SharedClassLoader;
import org.nuxeo.osgi.application.SharedClassLoaderImpl;
import org.osgi.framework.BundleException;

public class StandaloneBundleLoader
extends ApplicationLoader {
    protected SharedClassLoader loader;

    public StandaloneBundleLoader(OSGiAdapter osgi) {
        this(osgi, StandaloneBundleLoader.class.getClassLoader());
    }

    public StandaloneBundleLoader(OSGiAdapter osgi, ClassLoader parentLoader) {
        super(osgi);
        this.loader = new SharedClassLoaderImpl(parentLoader);
    }

    public StandaloneBundleLoader(OSGiAdapter osgi, SharedClassLoader scl) {
        super(osgi);
        this.loader = scl;
    }

    public void setSharedClassLoader(SharedClassLoader loader) {
        this.loader = loader;
    }

    public SharedClassLoader getSharedClassLoader() {
        return this.loader;
    }

    @Override
    public void installBundle(BundleFile bundleFile) throws BundleException {
        this.osgi.install(new BundleImpl(this.osgi, bundleFile, this.loader.getLoader()));
    }

    @Override
    public void loadBundle(BundleFile bundleFile) {
        this.loader.addURL(bundleFile.getURL());
    }

    @Override
    public void loadJAR(BundleFile bundleFile) {
        this.loader.addURL(bundleFile.getURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        File home = new File("/tmp/test_osgi_loader");
        OSGiAdapter osgi = new OSGiAdapter(home);
        System.out.println("Starting ...");
        StandaloneBundleLoader loader = new StandaloneBundleLoader(osgi);
        Thread.currentThread().setContextClassLoader(loader.loader.getLoader());
        double s = System.currentTimeMillis();
        try {
            loader.setExtractNestedJARs(true);
            loader.setScanForNestedJARs(true);
            ArrayList<BundleFile> bundles = new ArrayList<BundleFile>();
            ArrayList<BundleFile> jars = new ArrayList<BundleFile>();
            loader.load(new File("/opt/jboss/server/default/deploy/nuxeo.ear"), bundles, jars);
            loader.installAll(bundles);
            System.out.println(">>>> Loading done!!!!");
        }
        finally {
            System.out.println("Shutting down");
            osgi.shutdown();
        }
        double e = System.currentTimeMillis();
        System.out.println("Total time: " + (e - s) / 1000.0 + " sec.");
        System.exit(0);
    }
}

