/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.osgi;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.utils.JarUtils;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.osgi.BundleFile;
import org.nuxeo.osgi.BundleManifestReader;
import org.nuxeo.osgi.JarBundleFile;

public class DirectoryBundleFile
implements BundleFile {
    protected final File file;
    protected final Manifest mf;

    public DirectoryBundleFile(File file) throws IOException {
        this(file, JarUtils.getDirectoryManifest((File)file));
    }

    public DirectoryBundleFile(File file, Manifest mf) {
        this.file = file;
        this.mf = mf;
    }

    @Override
    public Enumeration<URL> findEntries(String name, String pattern, boolean recurse) {
        throw new UnsupportedOperationException("The operation BundleFile.findEntries() is not yet implemented");
    }

    @Override
    public URL getEntry(String name) {
        File entry = new File(this.file, name);
        if (entry.exists()) {
            try {
                return entry.toURI().toURL();
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public Enumeration<String> getEntryPaths(String path) {
        throw new UnsupportedOperationException("The operation BundleFile.geEntryPaths() is not yet implemented");
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public String getFileName() {
        return this.file.getName();
    }

    @Override
    public String getLocation() {
        return this.file.getPath();
    }

    @Override
    public Manifest getManifest() {
        return this.mf;
    }

    @Override
    public Collection<BundleFile> getNestedBundles(File tmpDir) throws IOException {
        Attributes attrs = this.mf.getMainAttributes();
        String cp = attrs.getValue("Bundle-ClassPath");
        if (cp == null) {
            cp = attrs.getValue("Class-Path");
        }
        if (cp == null) {
            return null;
        }
        String[] paths = StringUtils.split((String)cp, (char)',', (boolean)true);
        ArrayList<BundleFile> nested = new ArrayList<BundleFile>();
        for (String path : paths) {
            File nestedBundle = new File(this.file, path);
            if (nestedBundle.isDirectory()) {
                nested.add(new DirectoryBundleFile(nestedBundle));
                continue;
            }
            nested.add(new JarBundleFile(nestedBundle));
        }
        return nested;
    }

    @Override
    public Collection<BundleFile> findNestedBundles(File tmpDir) throws IOException {
        File[] files;
        ArrayList<BundleFile> nested = new ArrayList<BundleFile>();
        for (File jar : files = FileUtils.findFiles((File)this.file, (String)"*.jar", (boolean)true)) {
            if (jar.isDirectory()) {
                nested.add(new DirectoryBundleFile(jar));
                continue;
            }
            nested.add(new JarBundleFile(jar));
        }
        return nested;
    }

    @Override
    public String getSymbolicName() {
        try {
            String value = this.mf.getMainAttributes().getValue("Bundle-SymbolicName");
            return value == null ? null : BundleManifestReader.removePropertiesFromHeaderValue(value);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public URL getURL() {
        try {
            return this.file.toURI().toURL();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public boolean isJar() {
        return false;
    }

    public String toString() {
        return this.getLocation();
    }
}

