/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.osgi;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Map;
import java.util.jar.Manifest;
import org.nuxeo.osgi.BundleFile;
import org.nuxeo.osgi.BundleManifestReader;
import org.nuxeo.osgi.NullActivator;
import org.nuxeo.osgi.OSGiAdapter;
import org.nuxeo.osgi.OSGiBundleContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

public class BundleImpl
implements Bundle {
    protected final long id;
    protected final String symbolicName;
    protected final Dictionary<String, String> headers;
    protected final BundleContext context;
    protected final OSGiAdapter osgi;
    protected final BundleFile file;
    protected final ClassLoader loader;
    protected int state;
    protected long lastModified;
    protected BundleActivator activator;
    protected double startupTime;

    public BundleImpl(OSGiAdapter osgi, BundleFile file, ClassLoader loader) {
        this(osgi, file, loader, false);
    }

    public BundleImpl(OSGiAdapter osgi, BundleFile file, ClassLoader loader, boolean isSystemBundle) {
        this.osgi = osgi;
        this.loader = loader;
        this.file = file;
        Manifest mf = file.getManifest();
        if (mf == null) {
            this.headers = null;
            this.symbolicName = null;
            this.id = -1L;
            this.context = null;
            return;
        }
        this.headers = BundleManifestReader.getHeaders(mf);
        if (this.headers == null) {
            this.symbolicName = null;
            this.id = -1L;
            this.context = null;
            return;
        }
        this.symbolicName = this.headers.get("Bundle-SymbolicName");
        this.id = isSystemBundle ? 0L : osgi.getBundleId(this.symbolicName);
        this.context = this.createContext();
        this.state = 1;
    }

    public BundleFile getBundleFile() {
        return this.file;
    }

    protected final BundleContext createContext() {
        return new OSGiBundleContext(this);
    }

    public BundleContext getBundleContext() {
        return this.context;
    }

    public void start(int options) throws BundleException {
    }

    public void stop(int options) throws BundleException {
    }

    public String getLocation() {
        return this.file.getLocation();
    }

    public URL getResource(String name) {
        return this.loader.getResource(name);
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        return this.loader.getResources(name);
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loader.loadClass(name);
    }

    public URL getEntry(String name) {
        return this.file.getEntry(name);
    }

    public Enumeration<URL> findEntries(String path, String filePattern, boolean recurse) {
        return this.file.findEntries(path, filePattern, recurse);
    }

    public Enumeration<String> getEntryPaths(String path) {
        return this.file.getEntryPaths(path);
    }

    public long getBundleId() {
        return this.id;
    }

    public Dictionary<String, String> getHeaders() {
        return this.headers;
    }

    public Dictionary<String, String> getHeaders(String locale) {
        return this.headers;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public ServiceReference[] getRegisteredServices() {
        return null;
    }

    public ServiceReference[] getServicesInUse() {
        return null;
    }

    public int getState() {
        return this.state;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public boolean hasPermission(Object permission) {
        return true;
    }

    public BundleActivator getActivator() throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        if (this.activator == null) {
            String className = this.headers.get("Bundle-Activator");
            if (className == null) {
                this.activator = NullActivator.INSTANCE;
            } else {
                try {
                    this.activator = (BundleActivator)this.loadClass(className).newInstance();
                }
                catch (ClassNotFoundException e) {
                    this.activator = NullActivator.INSTANCE;
                    throw e;
                }
            }
        }
        return this.activator;
    }

    public void start() throws BundleException {
        try {
            this.setStarting();
            this.getActivator().start(this.context);
            this.setStarted();
        }
        catch (Exception e) {
            throw new BundleException("Failed to start activator: " + this.headers.get("Bundle-Activator"), (Throwable)e);
        }
    }

    public void stop() throws BundleException {
        try {
            this.setStopping();
            this.getActivator().stop(this.context);
            this.setStopped();
        }
        catch (Exception e) {
            throw new BundleException("Failed to stop activator: " + this.headers.get("Bundle-Activator"), (Throwable)e);
        }
    }

    public void shutdown() throws BundleException {
        try {
            this.state = 16;
            this.getActivator().stop(this.context);
            this.lastModified = System.currentTimeMillis();
            this.state = 1;
        }
        catch (Exception e) {
            throw new BundleException("Failed to stop activator: " + this.headers.get("Bundle-Activator"), (Throwable)e);
        }
    }

    public void uninstall() throws BundleException {
        this.osgi.uninstall(this);
    }

    public void update() throws BundleException {
        this.lastModified = System.currentTimeMillis();
        throw new UnsupportedOperationException("Bundle.update() operations was not yet implemented");
    }

    public void update(InputStream in) throws BundleException {
        this.lastModified = System.currentTimeMillis();
        throw new UnsupportedOperationException("Bundle.update() operations was not yet implemented");
    }

    void setInstalled() {
        if (this.state == 2) {
            return;
        }
        this.lastModified = System.currentTimeMillis();
        this.state = 2;
        BundleEvent event = new BundleEvent(1, (Bundle)this);
        this.osgi.fireBundleEvent(event);
    }

    void setUninstalled() {
        if (this.state == 1) {
            return;
        }
        this.lastModified = System.currentTimeMillis();
        this.state = 1;
        BundleEvent event = new BundleEvent(16, (Bundle)this);
        this.osgi.fireBundleEvent(event);
    }

    void setResolved() {
        if (this.state == 4) {
            return;
        }
        this.state = 4;
        BundleEvent event = new BundleEvent(32, (Bundle)this);
        this.osgi.fireBundleEvent(event);
    }

    void setUnResolved() {
        this.state = 2;
        BundleEvent event = new BundleEvent(64, (Bundle)this);
        this.osgi.fireBundleEvent(event);
    }

    void setStarting() {
        if (this.state != 4) {
            return;
        }
        this.state = 8;
        BundleEvent event = new BundleEvent(128, (Bundle)this);
        this.osgi.fireBundleEvent(event);
    }

    void setStarted() {
        if (this.state != 8) {
            return;
        }
        this.state = 32;
        BundleEvent event = new BundleEvent(2, (Bundle)this);
        this.osgi.fireBundleEvent(event);
    }

    void setStopping() {
        if (this.state != 32) {
            return;
        }
        this.state = 16;
        BundleEvent event = new BundleEvent(256, (Bundle)this);
        this.osgi.fireBundleEvent(event);
    }

    void setStopped() {
        if (this.state != 16) {
            return;
        }
        this.state = 4;
        BundleEvent event = new BundleEvent(4, (Bundle)this);
        this.osgi.fireBundleEvent(event);
    }

    public double getStartupTime() {
        return this.startupTime;
    }

    public int hashCode() {
        return this.symbolicName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Bundle) {
            return this.symbolicName.equals(((Bundle)obj).getSymbolicName());
        }
        return false;
    }

    public String toString() {
        return this.symbolicName;
    }

    public Map getSignerCertificates(int signersType) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Version getVersion() {
        throw new UnsupportedOperationException("not yet implemented");
    }
}

