/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.osgi.util.jar;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarFile;
import org.nuxeo.osgi.util.jar.JarFileFactoryCloser;
import org.nuxeo.osgi.util.jar.URLClassLoaderCloser;
import org.nuxeo.runtime.api.Framework;

public class JarFileCloser {
    protected URLClassLoaderCloser applicationCloser;
    protected Map<URLClassLoader, URLClassLoaderCloser> urlClassLoderClosers = new HashMap<URLClassLoader, URLClassLoaderCloser>();
    protected JarFileFactoryCloser factoryCloser = new JarFileFactoryCloser();

    public JarFileCloser(URLClassLoader resourcesCL, ClassLoader appCL) {
        if (appCL instanceof URLClassLoader) {
            this.applicationCloser = new URLClassLoaderCloser((URLClassLoader)appCL);
        }
    }

    public void close(JarFile file) throws IOException {
        file.close();
        URL location = new File(file.getName()).toURI().toURL();
        URLClassLoaderCloser sharedResourcesCloser = new URLClassLoaderCloser((URLClassLoader)Framework.getResourceLoader());
        if (!sharedResourcesCloser.close(location) && this.applicationCloser != null) {
            this.applicationCloser.close(location);
        }
        this.factoryCloser.close(location);
    }
}

