/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.osgi.application;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.nuxeo.osgi.application.SharedClassLoader;
import org.nuxeo.osgi.application.SharedClassLoaderImpl;
import org.nuxeo.osgi.application.StandaloneApplication;

public class Main {
    public static void main(String[] args) {
        ClassLoader parent;
        ClassLoader cl;
        if (args.length == 0) {
            System.err.println("No classpath specified");
            System.exit(10);
        }
        if (!((cl = Thread.currentThread().getContextClassLoader()) instanceof URLClassLoader)) {
            System.err.println("Not a valid class loader: " + cl);
            System.exit(10);
        }
        if ((parent = cl.getParent()) == null) {
            parent = ClassLoader.getSystemClassLoader();
        }
        try {
            RootClassLoader rootLoader = new RootClassLoader(parent, SharedClassLoader.class);
            SharedClassLoaderImpl classLoader = new SharedClassLoaderImpl(((URLClassLoader)cl).getURLs(), (ClassLoader)rootLoader);
            Thread.currentThread().setContextClassLoader(classLoader.getLoader());
            URL systemBundle = classLoader.getURLs()[0];
            List<File> cp = Main.buildClassPath(classLoader, args[0]);
            String[] tmp = new String[args.length - 1];
            System.arraycopy(args, 1, tmp, 0, tmp.length);
            args = tmp;
            Class<?> me = classLoader.loadClass(StandaloneApplication.class.getName());
            Method main = me.getMethod("main", URL.class, List.class, String[].class);
            main.invoke(null, systemBundle, cp, args);
        }
        catch (Exception e) {
            System.err.println("Failed to create application class loader.");
            e.printStackTrace();
            System.exit(11);
        }
    }

    public static List<File> buildClassPath(SharedClassLoader classLoader, String rawcp) {
        ArrayList<File> result = new ArrayList<File>();
        try {
            String[] cp;
            for (String entry : cp = rawcp.split(":")) {
                File entryFile;
                if (entry.endsWith("/.")) {
                    entryFile = new File(entry.substring(0, entry.length() - 2));
                    File[] files = entryFile.listFiles();
                    if (files == null) continue;
                    for (File file : files) {
                        result.add(file);
                        classLoader.addURL(file.toURI().toURL());
                    }
                    continue;
                }
                entryFile = new File(entry);
                result.add(entryFile);
                classLoader.addURL(entryFile.toURI().toURL());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        return result;
    }

    private static class RootClassLoader
    extends ClassLoader {
        private final Class<?> loaderClass;
        private final String loaderName;

        RootClassLoader(ClassLoader parent, Class<?> loaderClass) {
            super(parent);
            this.loaderClass = loaderClass;
            this.loaderName = loaderClass.getName();
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            if (this.loaderName.equals(name)) {
                return this.loaderClass;
            }
            throw new ClassNotFoundException(name);
        }
    }
}

