/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.osgi.application;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;
import org.nuxeo.osgi.BundleFile;
import org.nuxeo.osgi.DirectoryBundleFile;
import org.nuxeo.osgi.JarBundleFile;
import org.nuxeo.osgi.OSGiAdapter;
import org.nuxeo.osgi.application.StandaloneApplication;
import org.nuxeo.osgi.application.StandaloneBundleLoader;
import org.osgi.framework.BundleException;

public class ApplicationBundleLoader {
    protected StandaloneBundleLoader bundleLoader;
    protected final StandaloneApplication app;
    protected boolean useCache = false;
    protected boolean extractNestedJARs = true;
    protected boolean scanForNestedJARs = true;

    public ApplicationBundleLoader(StandaloneApplication app) {
        this(app, false);
    }

    public ApplicationBundleLoader(StandaloneApplication app, boolean useCache) {
        this.app = app;
        this.bundleLoader = new StandaloneBundleLoader(app);
        this.useCache = useCache;
    }

    public void setScanForNestedJARs(boolean scanForNestedJARs) {
        this.scanForNestedJARs = scanForNestedJARs;
    }

    public boolean getScanForNestedJARs() {
        return this.scanForNestedJARs;
    }

    public void setExtractNestedJARs(boolean extractNestedJARs) {
        this.extractNestedJARs = extractNestedJARs;
    }

    public boolean getExtractNestedJARs() {
        return this.extractNestedJARs;
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    public boolean getUseCache() {
        return this.useCache;
    }

    public StandaloneBundleLoader getBundleLoader() {
        return this.bundleLoader;
    }

    public File getCacheFile() {
        return new File(this.app.getDataDir(), "bundles.cache");
    }

    public ClassLoader loadBundles(List<File> classPath) throws IOException, BundleException {
        this.bundleLoader = new StandaloneBundleLoader((OSGiAdapter)this.app, this.app.getSharedClassLoader());
        Thread.currentThread().setContextClassLoader(this.bundleLoader.getSharedClassLoader().getLoader());
        this.aboutToStartRuntime();
        boolean scan = true;
        File file = this.getCacheFile();
        if (this.useCache && file.isFile()) {
            scan = false;
            try {
                this.fastLoad(file);
            }
            catch (IOException e) {
                scan = true;
            }
            catch (BundleException e) {
                scan = true;
            }
        }
        if (scan) {
            ArrayList<BundleFile> bundles = new ArrayList<BundleFile>();
            ArrayList<BundleFile> jars = new ArrayList<BundleFile>();
            this.scanAndLoad(classPath, bundles, jars);
            ApplicationBundleLoader.writeCache(file, bundles, jars);
            this.app.installAll(bundles);
        }
        this.runtimeStarted();
        return this.bundleLoader.getSharedClassLoader().getLoader();
    }

    public void scanAndLoad(List<File> classPath, List<BundleFile> bundles, List<BundleFile> jars) {
        this.bundleLoader.setScanForNestedJARs(this.scanForNestedJARs);
        this.bundleLoader.setExtractNestedJARs(this.extractNestedJARs);
        for (File file : classPath) {
            if (file.isFile()) {
                String name = file.getName();
                if (!name.endsWith(".jar") || name.endsWith(".rar") || name.endsWith(".zip") || name.endsWith(".sar")) continue;
                try {
                    JarFile jar = new JarFile(file);
                    JarBundleFile bf = new JarBundleFile(jar);
                    if (bf.getSymbolicName() != null) {
                        bundles.add(bf);
                        continue;
                    }
                    jars.add(bf);
                }
                catch (IOException e) {}
                continue;
            }
            if (!file.isDirectory()) continue;
            try {
                DirectoryBundleFile bf = new DirectoryBundleFile(file);
                if (bf.getSymbolicName() != null) {
                    bundles.add(bf);
                    continue;
                }
                jars.add(bf);
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeCache(File file, List<BundleFile> bundles, List<BundleFile> jars) throws IOException {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(file));
            for (BundleFile bf : bundles) {
                writer.append(bf.getFile().getAbsolutePath());
                writer.newLine();
            }
            writer.append("#");
            writer.newLine();
            for (BundleFile bf : jars) {
                writer.append(bf.getFile().getAbsolutePath());
                writer.newLine();
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fastLoad(File file) throws IOException, BundleException {
        BufferedReader reader = null;
        ArrayList<BundleFile> bundles = new ArrayList<BundleFile>();
        try {
            String line;
            reader = new BufferedReader(new FileReader(file));
            ArrayList<BundleFile> list = bundles;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) {
                    list = null;
                    continue;
                }
                BundleFile bf = null;
                File f = new File(line.trim());
                bf = f.isDirectory() ? new DirectoryBundleFile(f) : new JarBundleFile(f);
                this.bundleLoader.loadJAR(bf);
                if (list == null) continue;
                list.add(bf);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        this.app.installAll(bundles);
    }

    protected void aboutToStartRuntime() {
    }

    protected void runtimeStarted() {
    }
}

