/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.osgi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.osgi.BundleImpl;
import org.nuxeo.osgi.BundleRegistration;
import org.osgi.framework.BundleException;

public class BundleRegistry {
    private static final Log log = LogFactory.getLog(BundleRegistry.class);
    private final Map<Long, BundleRegistration> bundlesById = new HashMap<Long, BundleRegistration>();
    private final Map<String, BundleRegistration> bundles = new LinkedHashMap<String, BundleRegistration>();
    private final Map<String, Set<BundleRegistration>> pendings = new HashMap<String, Set<BundleRegistration>>();

    public void addBundleAlias(String alias, String symbolicName) {
        BundleRegistration breg = this.bundles.get(symbolicName);
        if (breg != null) {
            this.bundles.put(alias, breg);
        }
    }

    public synchronized BundleImpl getBundle(long id) {
        BundleRegistration reg = this.bundlesById.get(id);
        return reg == null ? null : reg.bundle;
    }

    public synchronized BundleImpl getBundle(String symbolicName) {
        BundleRegistration reg = this.bundles.get(symbolicName);
        return reg == null ? null : reg.bundle;
    }

    public synchronized BundleImpl[] getFragments(String symbolicName) {
        BundleRegistration reg = this.bundles.get(symbolicName);
        ArrayList<BundleImpl> fragments = new ArrayList<BundleImpl>();
        for (String id : reg.extendsMe) {
            fragments.add(this.getBundle(id));
        }
        return fragments.toArray(new BundleImpl[fragments.size()]);
    }

    public synchronized BundleImpl[] getInstalledBundles() {
        BundleImpl[] bundles = new BundleImpl[this.bundles.size()];
        int i = 0;
        for (BundleRegistration reg : this.bundles.values()) {
            bundles[i++] = reg.bundle;
        }
        return bundles;
    }

    public synchronized void install(BundleImpl bundle) throws BundleException {
        if (bundle.getState() == 1) {
            BundleRegistration reg = this.bundles.get(bundle.getSymbolicName());
            if (reg == null) {
                this.register(new BundleRegistration(bundle));
            } else {
                this.register(reg);
            }
        }
    }

    public synchronized void uninstall(BundleImpl bundle) throws BundleException {
        BundleRegistration reg;
        if (bundle.getState() != 1 && (reg = this.bundles.get(bundle.getSymbolicName())) != null) {
            this.unregister(reg);
        }
    }

    private void register(BundleRegistration reg) throws BundleException {
        BundleRegistration host;
        String hostBundleId = this.getFragmentHost(reg);
        if (hostBundleId != null && (host = this.bundles.get(hostBundleId)) == null) {
            reg.addUnresolvedDependency(hostBundleId);
        }
        if (reg.hasUnresolvedDependencies()) {
            this.doPostpone(reg);
        } else {
            this.doRegister(reg);
        }
    }

    protected void unregister(BundleRegistration reg) throws BundleException {
        if (this.getFragmentHost(reg) == null) {
            reg.bundle.stop();
        }
        reg.bundle.setUnResolved();
        this.bundles.remove(reg.bundle.getSymbolicName());
        this.bundlesById.remove(reg.bundle.getBundleId());
        reg.bundle.setUninstalled();
        for (String depOnMe : reg.dependsOnMe) {
            BundleRegistration depReg = this.bundles.get(depOnMe);
            if (depReg == null) continue;
            depReg.bundle.setUnResolved();
        }
    }

    protected void doPostpone(BundleRegistration reg) {
        String name = reg.bundle.getSymbolicName();
        log.info((Object)("Registering unresolved bundle: " + name));
        this.bundles.put(name, reg);
        this.bundlesById.put(reg.bundle.getBundleId(), reg);
        for (String dep : reg.waitingFor) {
            Set<BundleRegistration> regs = this.pendings.get(dep);
            if (regs == null) {
                regs = new HashSet<BundleRegistration>();
                this.pendings.put(dep, regs);
            }
            regs.add(reg);
        }
        reg.bundle.setInstalled();
    }

    protected void doRegister(BundleRegistration reg) throws BundleException {
        String name = reg.bundle.getSymbolicName();
        log.info((Object)("Registering resolved bundle: " + name));
        this.bundles.put(name, reg);
        this.bundlesById.put(reg.bundle.getBundleId(), reg);
        reg.bundle.setResolved();
        String hostBundleId = this.getFragmentHost(reg);
        if (hostBundleId != null) {
            BundleRegistration host = this.bundles.get(hostBundleId);
            host.addFragment(reg.bundle.getSymbolicName());
        } else {
            reg.bundle.start();
        }
        Set<BundleRegistration> regs = this.pendings.remove(name);
        if (regs != null) {
            for (BundleRegistration pendingReg : regs) {
                pendingReg.removeUnresolvedDependency(name);
                if (pendingReg.hasUnresolvedDependencies()) continue;
                this.doRegister(pendingReg);
            }
        }
    }

    private String getFragmentHost(BundleRegistration reg) {
        String hostBundleId = reg.bundle.getHeaders().get("Fragment-Host");
        if (hostBundleId == null) {
            return null;
        }
        int p = hostBundleId.indexOf(59);
        if (p > -1) {
            hostBundleId = hostBundleId.substring(0, p);
        }
        return hostBundleId;
    }

    public void shutdown() {
        BundleRegistration[] regs;
        for (BundleRegistration reg : regs = this.bundles.values().toArray(new BundleRegistration[this.bundles.size()])) {
            try {
                if (reg.bundle == null) continue;
                reg.bundle.shutdown();
            }
            catch (BundleException e) {
                log.error((Object)("Failed to stop bundle " + reg.bundle.getSymbolicName()), (Throwable)e);
            }
            catch (RuntimeException e) {
                log.error((Object)("Failed to stop bundle " + reg.bundle.getSymbolicName()), (Throwable)e);
            }
        }
    }
}

