/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.osgi.util.jar;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.jar.JarFile;

public class URLClassLoaderCloser {
    protected URLClassLoader loader;
    protected ArrayList<?> loaders;
    protected Field jarField;
    protected Method getJarFileMethod;
    protected HashMap<?, ?> lmap;

    public URLClassLoaderCloser(URLClassLoader loader) {
        try {
            this.introspectClassLoader(loader);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Cannot introspect url class loader " + loader, e);
        }
        catch (SecurityException e) {
            throw new RuntimeException("Cannot introspect url class loader " + loader, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot introspect url class loader " + loader, e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Cannot introspect url class loader " + loader, e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Cannot introspect url class loader " + loader, e);
        }
    }

    protected void introspectClassLoader(URLClassLoader loader) throws NoSuchFieldException, SecurityException, IllegalAccessException, ClassNotFoundException, NoSuchMethodException {
        this.loader = loader;
        Field ucpField = URLClassLoader.class.getDeclaredField("ucp");
        ucpField.setAccessible(true);
        Object ucp = ucpField.get(loader);
        Class<?> ucpClass = ucp.getClass();
        Field lmapField = ucpClass.getDeclaredField("lmap");
        lmapField.setAccessible(true);
        this.lmap = (HashMap)lmapField.get(ucp);
        Field loadersField = ucpClass.getDeclaredField("loaders");
        loadersField.setAccessible(true);
        this.loaders = (ArrayList)loadersField.get(ucp);
        Class<?> jarLoaderClass = URLClassLoaderCloser.getJarLoaderClass();
        this.jarField = jarLoaderClass.getDeclaredField("jar");
        this.jarField.setAccessible(true);
        this.getJarFileMethod = jarLoaderClass.getDeclaredMethod("getJarFile", URL.class);
        this.getJarFileMethod.setAccessible(true);
    }

    protected static Class<?> getJarLoaderClass() throws ClassNotFoundException {
        return URLClassLoaderCloser.class.getClassLoader().loadClass("sun.misc.URLClassPath$JarLoader");
    }

    protected static String serializeURL(URL location) {
        String str3;
        String str2;
        StringBuilder localStringBuilder = new StringBuilder(128);
        String str1 = location.getProtocol();
        if (str1 != null) {
            str1 = str1.toLowerCase();
            localStringBuilder.append(str1);
            localStringBuilder.append("://");
        }
        if ((str2 = location.getHost()) != null) {
            str2 = str2.toLowerCase();
            localStringBuilder.append(str2);
            int i = location.getPort();
            if (i == -1) {
                i = location.getDefaultPort();
            }
            if (i != -1) {
                localStringBuilder.append(":").append(i);
            }
        }
        if ((str3 = location.getFile()) != null) {
            localStringBuilder.append(str3);
        }
        return localStringBuilder.toString();
    }

    public boolean close(URL location) throws IOException {
        Object loader;
        if (this.lmap.isEmpty()) {
            return false;
        }
        Object firstKey = this.lmap.keySet().iterator().next();
        Object obj = loader = firstKey instanceof URL ? this.lmap.remove(location) : this.lmap.remove(URLClassLoaderCloser.serializeURL(location));
        if (loader == null) {
            return false;
        }
        this.loaders.remove(loader);
        JarFile jar = null;
        try {
            jar = (JarFile)this.jarField.get(loader);
            this.jarField.set(loader, null);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Cannot use reflection on url class path", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot use reflection on url class path", e);
        }
        jar.close();
        return true;
    }
}

