/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.pubsub;

import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.pubsub.PubSubProvider;

public abstract class AbstractPubSubProvider
implements PubSubProvider {
    private final Log log = LogFactory.getLog(AbstractPubSubProvider.class);
    protected String namespace;
    protected Map<String, List<BiConsumer<String, byte[]>>> subscribers;

    @Override
    public void initialize(Map<String, String> options, Map<String, List<BiConsumer<String, byte[]>>> subscribers) {
        this.subscribers = subscribers;
    }

    @Override
    public void close() {
    }

    public void localPublish(String topic, byte[] message) {
        if (this.subscribers == null) {
            return;
        }
        List<BiConsumer<String, byte[]>> subs = this.subscribers.get(topic);
        if (subs != null) {
            for (BiConsumer<String, byte[]> subscriber : subs) {
                try {
                    subscriber.accept(topic, message);
                }
                catch (RuntimeException e) {
                    if (Thread.currentThread().isInterrupted()) {
                        throw e;
                    }
                    this.log.error((Object)("Exception in subscriber for topic: " + topic), (Throwable)e);
                }
            }
        }
    }
}

