/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.pubsub;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.pubsub.MemPubSubProvider;
import org.nuxeo.runtime.pubsub.PubSubProvider;
import org.nuxeo.runtime.pubsub.PubSubProviderDescriptor;
import org.nuxeo.runtime.pubsub.PubSubService;

public class PubSubServiceImpl
extends DefaultComponent
implements PubSubService {
    public static final String XP_CONFIG = "configuration";
    protected PubSubProvider provider;
    protected Map<String, List<BiConsumer<String, byte[]>>> subscribers = new ConcurrentHashMap<String, List<BiConsumer<String, byte[]>>>();
    protected Map<String, String> options;

    public void deactivate(ComponentContext context) {
        this.subscribers.clear();
        this.provider.close();
        this.provider = null;
        super.deactivate(context);
    }

    public void start(ComponentContext context) {
        List descs;
        PubSubProviderDescriptor providerDescriptor;
        super.start(context);
        if (this.provider != null) {
            this.provider.close();
        }
        PubSubProviderDescriptor pubSubProviderDescriptor = providerDescriptor = (descs = this.getDescriptors(XP_CONFIG)).isEmpty() ? null : (PubSubProviderDescriptor)descs.get(descs.size() - 1);
        if (providerDescriptor == null) {
            this.provider = new MemPubSubProvider();
            this.options = Collections.emptyMap();
        } else {
            Class<? extends PubSubProvider> klass = providerDescriptor.klass;
            if (!PubSubProvider.class.isAssignableFrom(klass)) {
                throw new RuntimeException("Class does not implement PubSubServiceProvider: " + klass.getName());
            }
            try {
                this.provider = klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.options = providerDescriptor.options;
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
        this.provider.initialize(this.options, this.subscribers);
    }

    public void stop(ComponentContext context) throws InterruptedException {
        super.stop(context);
        if (this.provider == null) {
            return;
        }
        this.provider.close();
    }

    public int getApplicationStartedOrder() {
        return -490;
    }

    @Override
    public void publish(String topic, byte[] message) {
        this.provider.publish(topic, message);
    }

    @Override
    public void registerSubscriber(String topic, BiConsumer<String, byte[]> subscriber) {
        this.subscribers.computeIfAbsent(topic, k -> new CopyOnWriteArrayList()).add(subscriber);
    }

    @Override
    public void unregisterSubscriber(String topic, BiConsumer<String, byte[]> subscriber) {
        this.subscribers.computeIfAbsent(topic, k -> new CopyOnWriteArrayList()).remove(subscriber);
    }
}

