/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.reload;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.nuxeo.runtime.RuntimeServiceException;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.reload.ReloadContext;
import org.nuxeo.runtime.reload.ReloadResult;
import org.nuxeo.runtime.reload.ReloadService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class DevReloadBridge {
    public Map<String, String> reloadBundles(List<String> bundleNamesToUndeploy, List<File> bundlesToDeploy) {
        ReloadService reloadService = (ReloadService)Framework.getService(ReloadService.class);
        ReloadContext context = new ReloadContext("dev-bundles").undeploy(bundleNamesToUndeploy).deploy(bundlesToDeploy);
        try {
            ReloadResult result = reloadService.reloadBundles(context);
            return result.deployedBundles().stream().collect(Collectors.toMap(Bundle::getSymbolicName, Bundle::getLocation));
        }
        catch (BundleException e) {
            throw new RuntimeServiceException("Unable to reload server", (Throwable)e);
        }
    }
}

