/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.reload;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class ReloadContext {
    protected final List<String> bundlesNamesToUndeploy = new ArrayList<String>();
    protected final List<File> bundlesToDeploy = new ArrayList<File>();
    protected final Path bundlesDestination;

    public ReloadContext() {
        this("bundles");
    }

    public ReloadContext(String bundlesDestination) {
        this(Paths.get(bundlesDestination, new String[0]));
    }

    public ReloadContext(Path bundlesDestination) {
        this.bundlesDestination = Objects.requireNonNull(bundlesDestination, "Bundles destination must not be null");
    }

    public ReloadContext undeploy(List<String> bundleNames) {
        this.bundlesNamesToUndeploy.addAll(bundleNames);
        return this;
    }

    public ReloadContext undeploy(String ... bundleNames) {
        return this.undeploy(Arrays.asList(bundleNames));
    }

    public ReloadContext deploy(List<File> bundleFiles) {
        this.bundlesToDeploy.addAll(bundleFiles);
        return this;
    }

    public ReloadContext deploy(File ... bundleFiles) {
        return this.deploy(Arrays.asList(bundleFiles));
    }
}

