/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.reload;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.Environment;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.utils.ZipUtils;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.SharedResourceLoader;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.reload.MutableClassLoaderDelegate;
import org.nuxeo.runtime.reload.ReloadService;
import org.nuxeo.runtime.services.event.Event;
import org.nuxeo.runtime.services.event.EventService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ReloadComponent
extends DefaultComponent
implements ReloadService {
    private static final Log log = LogFactory.getLog(ReloadComponent.class);
    public static String RELOAD_TOPIC = "org.nuxeo.runtime.reload";
    protected static Bundle bundle;

    public static BundleContext getBundleContext() {
        return bundle.getBundleContext();
    }

    public static Bundle getBundle() {
        return bundle;
    }

    public void activate(ComponentContext context) throws Exception {
        super.activate(context);
        bundle = context.getRuntimeContext().getBundle();
    }

    public void deactivate(ComponentContext context) throws Exception {
        super.deactivate(context);
        bundle = null;
    }

    @Override
    public void flushJassCache() throws Exception {
        EventService eventService = (EventService)Framework.getLocalService(EventService.class);
        eventService.sendEvent(new Event("usermanager", "user_changed", (Object)this, (Object)"Deployer"));
    }

    @Override
    public void reloadRepository() throws Exception {
        ((EventService)Framework.getLocalService(EventService.class)).sendEvent(new Event(RELOAD_TOPIC, "reloadRepositories", (Object)this, null));
    }

    @Override
    public void addJar(File file) throws Exception {
        MutableClassLoaderDelegate mcl = new MutableClassLoaderDelegate(ReloadComponent.class.getClassLoader());
        mcl.addURL(file.toURI().toURL());
    }

    @Override
    public void removeJar(File file) throws Exception {
    }

    public void deployBundle(File file, boolean reloadResourceClassPath) throws Exception {
        String path = file.getAbsolutePath();
        if (reloadResourceClassPath) {
            ReloadComponent.reloadResourceClassPath(Collections.singletonList(path));
        }
        try {
            this.addJar(file);
        }
        catch (Throwable t) {
            log.error((Object)("Failed to modify classloader. tried to add: " + file), t);
        }
        Bundle bundle = Framework.getRuntime().getContext().getBundle().getBundleContext().installBundle(path);
        bundle.start();
        ReloadComponent.processFragment(file);
        this.reloadRepository();
    }

    @Override
    public void deployBundle(File file) throws Exception {
        this.deployBundle(file, true);
    }

    @Override
    public void reloadProperties() throws Exception {
        Framework.getRuntime().reloadProperties();
    }

    public static void reloadResourceClassPath(Collection<String> files) throws Exception {
        Framework.reloadResourceLoader();
        SharedResourceLoader loader = Framework.getResourceLoader();
        for (String path : files) {
            URL url = new File(path).toURI().toURL();
            loader.addURL(url);
        }
    }

    public static void processFragment(File file) throws Exception {
        log.info((Object)"running fragment processor");
        if (file.isDirectory()) {
            File war = new File(file, "web");
            if ((war = new File(war, "nuxeo.war")).isDirectory()) {
                FileUtils.copyTree((File)war, (File)ReloadComponent.getAppDir());
            } else {
                war = new File(file, "nuxeo.war");
                if (war.isDirectory()) {
                    FileUtils.copyTree((File)war, (File)ReloadComponent.getAppDir());
                }
            }
        } else if (file.isFile()) {
            File war = ReloadComponent.getWarDir();
            ZipUtils.unzip((String)"web/nuxeo.war", (File)file, (File)war);
            ZipUtils.unzip((String)"nuxeo.war", (File)file, (File)war);
        }
    }

    public static File getAppDir() {
        return Environment.getDefault().getConfig().getParentFile();
    }

    public static File getWarDir() {
        return new File(ReloadComponent.getAppDir(), "nuxeo.war");
    }
}

