/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.services.streaming;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.remoting.RemotingService;
import org.nuxeo.runtime.remoting.transporter.TransporterServer;
import org.nuxeo.runtime.services.streaming.StreamManager;
import org.nuxeo.runtime.services.streaming.StreamManagerClient;
import org.nuxeo.runtime.services.streaming.StreamManagerServer;

public class StreamingService
extends DefaultComponent {
    private static final Log log = LogFactory.getLog(StreamingService.class);
    public static final ComponentName NAME = new ComponentName("org.nuxeo.runtime.streaming");
    protected StreamManager manager;
    protected ComponentContext context;
    protected boolean isServer;
    protected String serverLocator;

    public void activate(ComponentContext context) throws Exception {
        this.context = context;
        String val = Framework.getProperty((String)"org.nuxeo.runtime.streaming.isServer", (String)"true");
        this.isServer = val.equalsIgnoreCase("true");
        this.serverLocator = Framework.getProperty((String)"org.nuxeo.runtime.streaming.serverLocator");
        boolean isServerEnabled = Framework.getProperty((String)"org.nuxeo.runtime.server.enabled", (String)"true").equalsIgnoreCase("true");
        if (isServerEnabled) {
            this.startManager();
        }
    }

    public void deactivate(ComponentContext context) throws Exception {
        this.stopManager();
        this.context = null;
        super.deactivate(context);
    }

    public void setServer(boolean isServer) {
        this.isServer = isServer;
    }

    public void setServerLocator(String serverLocator) {
        this.serverLocator = serverLocator;
    }

    public boolean isServer() {
        return this.isServer;
    }

    public String getServerLocator() {
        return this.serverLocator;
    }

    public ComponentContext getContext() {
        return this.context;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
    }

    public StreamManager getStreamManager() {
        return this.manager;
    }

    public synchronized void startManager() throws Exception {
        if (this.manager != null) {
            throw new IllegalStateException("StreamingManager is already started");
        }
        if (this.isServer) {
            File tmpDir = new File(Framework.getRuntime().getHome(), "tmp/uploads");
            RemotingService remoting = (RemotingService)((Object)Framework.getRuntime().getComponent(RemotingService.NAME));
            if (remoting == null) {
                throw new IllegalStateException("Cannot start manager. RemotingService not available.");
            }
            TransporterServer transporterServer = remoting.getTransporterServer();
            if (transporterServer != null) {
                this.manager = new StreamManagerServer(transporterServer, tmpDir);
                this.serverLocator = transporterServer.getLocatorURI();
            } else {
                String msg = "Streaming Transporter Server is not defined. Streaming will not work.";
                log.warn((Object)msg);
                Framework.getRuntime().getWarnings().add(msg);
            }
        } else if (this.serverLocator == null) {
            String msg = "Streaming Server Locator is not defined. Streaming will not work.";
            log.warn((Object)msg);
            Framework.getRuntime().getWarnings().add(msg);
        } else {
            int minBufSize = (Integer)this.context.getPropertyValue("minBufferSize", (Object)8192);
            int maxBufSize = (Integer)this.context.getPropertyValue("maxBufferSize", (Object)0x800000);
            this.manager = new StreamManagerClient(this.serverLocator, minBufSize, maxBufSize);
        }
        if (this.manager != null) {
            this.manager.start();
        }
    }

    public synchronized void stopManager() throws Exception {
        if (this.manager != null) {
            this.manager.stop();
            this.manager = null;
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (StreamManager.class.isAssignableFrom(adapter)) {
            return (T)this.manager;
        }
        return null;
    }
}

