/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.remoting;

import java.util.Iterator;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.marshal.MarshalFactory;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.marshal.serializable.SerializableMarshaller;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.config.ConfigurationFactory;
import org.nuxeo.runtime.config.v1.ConfigurationFactory1;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.RuntimeContext;
import org.nuxeo.runtime.remoting.Server;
import org.nuxeo.runtime.remoting.ServerImpl;
import org.nuxeo.runtime.remoting.transporter.NuxeoUnMarshaller;
import org.nuxeo.runtime.remoting.transporter.TransporterClient;
import org.nuxeo.runtime.remoting.transporter.TransporterServer;

public class RemotingService
extends DefaultComponent {
    public static final String INVOKER_NAME = "nx:service=invoker,name=remoting";
    public static final ComponentName NAME = new ComponentName("org.nuxeo.runtime.remoting.RemotingService");
    public static final String DEFAULT_LOCATOR = "socket://0.0.0.0:62474/?datatype=nuxeo";
    private TransporterServer transporterServer;
    private Server server;
    private boolean isServer;
    private InvokerLocator serverLocator;

    public static Server connect(String locatorURI) throws Exception {
        return (Server)TransporterClient.createTransporterClient(new InvokerLocator(locatorURI), Server.class);
    }

    public static Server connect(String host, int port) throws Exception {
        return RemotingService.connect(RemotingService.getServerURI(host, port));
    }

    public static void disconnect(Server server) {
        TransporterClient.destroyTransporterClient(server);
    }

    @Deprecated
    public static String getServerURI(String host, int port) {
        return "socket://" + host + ':' + port + "/?datatype=nuxeo";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static String ping(String host, int port) {
        String string;
        Server server = RemotingService.connect(host, port);
        try {
            string = server.getProductInfo();
        }
        catch (Throwable throwable) {
            try {
                TransporterClient.destroyTransporterClient(server);
                throw throwable;
            }
            catch (Throwable throwable2) {
                return null;
            }
        }
        TransporterClient.destroyTransporterClient(server);
        return string;
    }

    public void activate(ComponentContext context) throws Exception {
        ConfigurationFactory.registerFactory(new ConfigurationFactory1());
        MarshalFactory.addMarshaller((String)"nuxeo", (Marshaller)new SerializableMarshaller(), (UnMarshaller)new NuxeoUnMarshaller());
        String val = Framework.getProperty((String)"org.nuxeo.runtime.server.enabled", (String)"true");
        this.isServer = val.equalsIgnoreCase("true");
        if (this.isServer) {
            MBeanServer mb;
            String locator = Framework.getProperty((String)"org.nuxeo.runtime.server.locator", (String)DEFAULT_LOCATOR);
            RuntimeContext runtimeContext = context.getRuntimeContext();
            this.server = new ServerImpl(this, runtimeContext.getRuntime());
            this.serverLocator = new InvokerLocator(locator);
            this.transporterServer = TransporterServer.createTransporterServer(this.serverLocator, (Object)this.server, Server.class.getName());
            Iterator<MBeanServer> it = MBeanServerFactory.findMBeanServer(null).iterator();
            if (it.hasNext() && (mb = it.next()) != null) {
                mb.registerMBean(this.transporterServer.getConnector().getServerInvoker(), new ObjectName(INVOKER_NAME));
            }
        }
    }

    public InvokerLocator getServerLocator() {
        return this.serverLocator;
    }

    public TransporterServer getTransporterServer() {
        return this.transporterServer;
    }

    public void deactivate(ComponentContext context) throws Exception {
        if (this.transporterServer != null) {
            this.transporterServer.stop();
            this.transporterServer = null;
        }
        this.serverLocator = null;
        this.isServer = false;
        this.server = null;
    }

    public Server getServer() {
        return this.server;
    }

    public boolean isServer() {
        return this.isServer;
    }

    public static void main(String[] args) {
        try {
            Server server = RemotingService.connect("servlet://localhost:8080/nuxeo/ServerInvokerServlet");
            Properties props = server.getProperties();
            System.out.println(props);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

