/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.runtime.server.InitParamDescriptor;

@XObject(value="servlet")
public class ServletDescriptor {
    @XNode(value="@context")
    protected String context;
    @XNode(value="servlet-name")
    protected String name;
    @XNode(value="servlet-class")
    protected Class<?> clazz;
    @XNodeList(value="url-pattern", type=ArrayList.class, componentType=String.class)
    protected List<String> urlPatterns;
    protected Map<String, String> initParams = new HashMap<String, String>();
    @XNode(value="display-name")
    protected String displayName;

    @XNode(value="@name")
    public void setName(String name) {
        this.name = name;
    }

    @XNode(value="@class")
    public void setClass(Class<?> clazz) {
        this.clazz = clazz;
    }

    @XNode(value="@path")
    public void setUrlPattern(String urlPattern) {
        this.urlPatterns = new ArrayList<String>(Arrays.asList(urlPattern));
    }

    @XNodeList(value="init-param", type=ArrayList.class, componentType=InitParamDescriptor.class)
    public void setInitParams(List<InitParamDescriptor> descriptors) {
        for (InitParamDescriptor d : descriptors) {
            this.initParams.put(d.getName(), d.getValue());
        }
    }

    @XNodeMap(value="init-params/param", key="@name", type=HashMap.class, componentType=String.class, trim=true, nullByDefault=true)
    public void setInitParams(Map<String, String> initParams) {
        this.initParams.putAll(initParams);
    }

    @XNode(value="description")
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getContext() {
        return this.context;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public List<String> getUrlPatterns() {
        return this.urlPatterns;
    }

    public Map<String, String> getInitParams() {
        return this.initParams;
    }

    public String getDisplayName() {
        return this.displayName;
    }
}

