/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.server;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.server.WebApplication;
import org.nuxeo.runtime.RuntimeServiceException;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.server.FilterDescriptor;
import org.nuxeo.runtime.server.ServerConfigurator;
import org.nuxeo.runtime.server.ServletContextListenerDescriptor;
import org.nuxeo.runtime.server.ServletDescriptor;

public class ServerComponent
extends DefaultComponent {
    private static final Log log = LogFactory.getLog(ServerComponent.class);
    public static final String XP_WEB_APP = "webapp";
    public static final String XP_SERVLET = "servlet";
    public static final String XP_FILTER = "filter";
    public static final String XP_LISTENER = "listener";
    public static final String PORT_SYSTEM_PROP = "nuxeo.servlet-container.port";
    protected static final String CONFIGURATOR_CLASS = "org.nuxeo.runtime.server.tomcat.TomcatServerConfigurator";
    protected ServerConfigurator configurator;

    public void activate(ComponentContext context) {
        try {
            this.configurator = (ServerConfigurator)Class.forName(CONFIGURATOR_CLASS).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeServiceException((Throwable)e);
        }
        int p = -1;
        String configPort = System.getProperty(PORT_SYSTEM_PROP);
        if (StringUtils.isNotBlank((CharSequence)configPort)) {
            try {
                p = Integer.parseInt(configPort);
            }
            catch (NumberFormatException e) {
                log.error((Object)("Invalid port for embedded servlet container: " + configPort));
            }
        }
        this.configurator.initialize(p);
    }

    public void deactivate(ComponentContext context) {
        this.configurator.close();
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (XP_WEB_APP.equals(extensionPoint)) {
            this.configurator.addWepApp((WebApplication)contribution);
        } else if (XP_FILTER.equals(extensionPoint)) {
            this.configurator.addFilter((FilterDescriptor)contribution);
        } else if (XP_SERVLET.equals(extensionPoint)) {
            this.configurator.addServlet((ServletDescriptor)contribution);
        } else if (XP_LISTENER.equals(extensionPoint)) {
            this.configurator.addLifecycleListener((ServletContextListenerDescriptor)contribution);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
    }

    public int getApplicationStartedOrder() {
        return -100;
    }

    public void start(ComponentContext context) {
        this.configurator.start();
    }

    public void stop(ComponentContext context) {
        this.configurator.stop();
    }
}

