/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.server.tomcat;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Map;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.tomcat.util.descriptor.web.FilterDef;
import org.apache.tomcat.util.descriptor.web.FilterMap;
import org.apache.tomcat.util.scan.StandardJarScanner;
import org.nuxeo.common.Environment;
import org.nuxeo.common.server.WebApplication;
import org.nuxeo.runtime.RuntimeServiceException;
import org.nuxeo.runtime.server.FilterDescriptor;
import org.nuxeo.runtime.server.FilterMappingDescriptor;
import org.nuxeo.runtime.server.ServerConfigurator;
import org.nuxeo.runtime.server.ServletContextListenerDescriptor;
import org.nuxeo.runtime.server.ServletDescriptor;

public class TomcatServerConfigurator
implements ServerConfigurator {
    private static final Logger log = LogManager.getLogger(TomcatServerConfigurator.class);
    protected Tomcat tomcat;

    @Override
    public int initialize(int port) {
        this.tomcat = new Tomcat();
        this.tomcat.setBaseDir(".");
        this.tomcat.setHostname("localhost");
        this.tomcat.setPort(port);
        Connector connector = this.tomcat.getConnector();
        connector.setProperty("maxKeepAliveRequests", "1");
        connector.setProperty("socket.soReuseAddress", "true");
        log.info("Configuring test Tomcat on port: {}", (Object)port);
        return port;
    }

    @Override
    public void close() {
        this.tomcat = null;
    }

    @Override
    public void start() {
        try {
            this.tomcat.start();
        }
        catch (LifecycleException e) {
            throw new RuntimeServiceException((Throwable)e);
        }
    }

    @Override
    public void stop() {
        if (this.tomcat == null) {
            return;
        }
        try {
            this.tomcat.stop();
            File workDirectory = Paths.get(this.tomcat.getServer().getCatalinaHome().getAbsolutePath(), "work").toFile();
            FileUtils.deleteDirectory((File)workDirectory);
            this.tomcat.destroy();
        }
        catch (IOException | LifecycleException e) {
            throw new RuntimeServiceException(e);
        }
    }

    @Override
    public void addWepApp(WebApplication descriptor) {
        String contextPath = this.normalizeContextPath(descriptor.getContextPath());
        File home = Environment.getDefault().getHome();
        File docBase = new File(home, descriptor.getWebRoot());
        docBase.mkdirs();
        Context context = this.tomcat.addWebapp(contextPath, docBase.getAbsolutePath());
        StandardJarScanner jarScanner = (StandardJarScanner)context.getJarScanner();
        jarScanner.setScanManifest(false);
        jarScanner.setScanAllDirectories(false);
        jarScanner.setScanAllFiles(false);
        jarScanner.setScanBootstrapClassPath(false);
        jarScanner.setScanClassPath(false);
    }

    @Override
    public void addFilter(FilterDescriptor descriptor) {
        String name = descriptor.getName();
        Context context = this.getContextForPath(descriptor.getContext());
        FilterDef filterDef = new FilterDef();
        filterDef.setFilterName(name);
        filterDef.setDisplayName(descriptor.getDisplayName());
        filterDef.setFilterClass(descriptor.getClazz().getName());
        Map<String, String> initParams = descriptor.getInitParams();
        if (initParams != null) {
            filterDef.getParameterMap().putAll(initParams);
        }
        context.addFilterDef(filterDef);
        for (FilterMappingDescriptor fmd : descriptor.getFilterMappings()) {
            FilterMap filterMap = new FilterMap();
            filterMap.setFilterName(name);
            filterMap.addURLPatternDecoded(fmd.getUrlPattern());
            for (String dispatch : fmd.getDispatchers()) {
                filterMap.setDispatcher(dispatch);
            }
            context.addFilterMap(filterMap);
        }
    }

    @Override
    public void addServlet(ServletDescriptor descriptor) {
        String name = descriptor.getName();
        Context context = this.getContextForPath(descriptor.getContext());
        Container previous = context.findChild(name);
        if (previous != null) {
            context.removeChild(previous);
        }
        Wrapper servlet = Tomcat.addServlet((Context)context, (String)name, (String)descriptor.getClazz().getName());
        Map<String, String> initParams = descriptor.getInitParams();
        if (initParams != null) {
            for (Map.Entry entry : initParams.entrySet()) {
                servlet.addInitParameter((String)entry.getKey(), (String)entry.getValue());
            }
        }
        for (String string : descriptor.getUrlPatterns()) {
            context.addServletMappingDecoded(string, name);
        }
    }

    @Override
    public void addLifecycleListener(ServletContextListenerDescriptor descriptor) {
        Context context = this.getContextForPath(descriptor.getContext());
        context.addApplicationListener(descriptor.getClazz().getName());
    }

    protected Context getContextForPath(String contextPath) {
        contextPath = this.normalizeContextPath(contextPath);
        Context context = (Context)this.tomcat.getHost().findChild(contextPath);
        if (context == null) {
            context = this.tomcat.addContext(contextPath, null);
        }
        return context;
    }

    protected String normalizeContextPath(String contextPath) {
        if (contextPath.equals("/")) {
            contextPath = "";
        }
        return contextPath;
    }
}

