/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.stream.tests;

import java.util.Arrays;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.lib.stream.computation.AbstractComputation;
import org.nuxeo.lib.stream.computation.ComputationContext;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.lib.stream.computation.Topology;
import org.nuxeo.runtime.stream.StreamProcessorTopology;

public class MyStreamProcessor
implements StreamProcessorTopology {
    private static final Log log = LogFactory.getLog(MyStreamProcessor.class);

    public Topology getTopology(Map<String, String> options) {
        return Topology.builder().addComputation(() -> new ComputationNoop("myComputation"), Arrays.asList("i1:input", "o1:s1")).addComputation(() -> new ComputationNoop("myComputation2"), Arrays.asList("i1:s1", "o1:output")).build();
    }

    protected static class ComputationNoop
    extends AbstractComputation {
        public ComputationNoop(String name) {
            super(name, 1, 1);
        }

        public void processRecord(ComputationContext context, String inputStreamName, Record record) {
            log.debug((Object)(this.metadata.name() + " got record: " + record));
            context.produceRecord("o1", record);
            context.askForCheckpoint();
        }
    }
}

