/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.stream;

import io.dropwizard.metrics5.Counter;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.SharedMetricRegistries;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import org.nuxeo.lib.stream.computation.log.ComputationRunner;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.management.api.Probe;
import org.nuxeo.runtime.management.api.ProbeStatus;
import org.nuxeo.runtime.services.config.ConfigurationService;

public class StreamProbe
implements Probe {
    public static final String STREAM_PROBE_DELAY_PROPERTY = "nuxeo.stream.health.check.delay";
    public static final Duration STREAM_PROBE_DELAY_DEFAULT = Duration.ofHours(36L);
    protected static final String FAILURE_MESSAGE = "%d computations have been terminated after failure. First failure detected: %s, probe failure delayed by %s. This Nuxeo instance must be restarted within the stream retention period.";
    protected Counter globalFailureCount;
    protected Long detected;
    protected Duration timeout;
    protected static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ssz").withZone(ZoneOffset.UTC);

    public ProbeStatus run() {
        long failures = this.getFailures();
        if (failures == 0L) {
            return ProbeStatus.newSuccess((String)"No failure");
        }
        String dateFailure = FORMATTER.format(Instant.ofEpochMilli(this.detected));
        String message = String.format(FAILURE_MESSAGE, failures, dateFailure, this.getTimeout());
        if (System.currentTimeMillis() - this.detected < this.getTimeout().toMillis()) {
            return ProbeStatus.newSuccess((String)message);
        }
        return ProbeStatus.newFailure((String)message);
    }

    protected Duration getTimeout() {
        if (this.timeout == null) {
            ConfigurationService confService = (ConfigurationService)Framework.getService(ConfigurationService.class);
            this.timeout = confService.getDuration(STREAM_PROBE_DELAY_PROPERTY, STREAM_PROBE_DELAY_DEFAULT);
        }
        return this.timeout;
    }

    protected long getFailures() {
        long failures = this.getCounter().getCount();
        if (failures > 0L && this.detected == null) {
            this.detected = System.currentTimeMillis();
        }
        return failures;
    }

    protected Counter getCounter() {
        if (this.globalFailureCount == null) {
            MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)"org.nuxeo.runtime.metrics.MetricsService");
            this.globalFailureCount = registry.counter(ComputationRunner.GLOBAL_FAILURE_COUNT_REGISTRY_NAME);
        }
        return this.globalFailureCount;
    }

    public void reset() {
        long count = this.getCounter().getCount();
        if (count > 0L) {
            this.getCounter().dec(count);
        }
        this.detected = null;
    }
}

