/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.stream;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.lib.stream.StreamRuntimeException;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.lib.stream.computation.Settings;
import org.nuxeo.lib.stream.computation.StreamManager;
import org.nuxeo.lib.stream.computation.StreamProcessor;
import org.nuxeo.lib.stream.computation.Topology;
import org.nuxeo.lib.stream.computation.log.LogStreamManager;
import org.nuxeo.lib.stream.log.chronicle.ChronicleLogManager;
import org.nuxeo.lib.stream.log.kafka.KafkaLogManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.codec.CodecService;
import org.nuxeo.runtime.kafka.KafkaConfigService;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentManager;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.stream.LogConfigDescriptor;
import org.nuxeo.runtime.stream.StreamProcessorDescriptor;
import org.nuxeo.runtime.stream.StreamService;

public class StreamServiceImpl
extends DefaultComponent
implements StreamService {
    private static final Logger log = LogManager.getLogger(StreamServiceImpl.class);
    public static final String NUXEO_STREAM_DIR_PROP = "nuxeo.stream.chronicle.dir";
    public static final String NUXEO_STREAM_RET_DURATION_PROP = "nuxeo.stream.chronicle.retention.duration";
    public static final String DEFAULT_CODEC = "avro";
    protected static final String XP_LOG_CONFIG = "logConfig";
    protected static final String XP_STREAM_PROCESSOR = "streamProcessor";
    protected final Map<String, org.nuxeo.lib.stream.log.LogManager> logManagers = new HashMap<String, org.nuxeo.lib.stream.log.LogManager>();
    protected final Map<String, StreamManager> streamManagers = new HashMap<String, StreamManager>();
    protected final Map<String, StreamProcessor> processors = new HashMap<String, StreamProcessor>();

    public int getApplicationStartedOrder() {
        return -590;
    }

    @Override
    public org.nuxeo.lib.stream.log.LogManager getLogManager(String name) {
        if (!this.logManagers.containsKey(name)) {
            LogConfigDescriptor config = (LogConfigDescriptor)this.getDescriptor(XP_LOG_CONFIG, name);
            if (config == null || !config.isEnabled()) {
                throw new IllegalArgumentException("Unknown or disabled logConfig: " + name);
            }
            if ("kafka".equalsIgnoreCase(config.type)) {
                this.logManagers.put(name, this.createKafkaLogManager(config));
            } else {
                this.logManagers.put(name, this.createChronicleLogManager(config));
            }
        }
        return this.logManagers.get(name);
    }

    @Override
    public StreamManager getStreamManager(String name) {
        return this.streamManagers.computeIfAbsent(name, app -> new LogStreamManager(this.getLogManager(name)));
    }

    protected org.nuxeo.lib.stream.log.LogManager createKafkaLogManager(LogConfigDescriptor config) {
        String kafkaConfig = config.options.getOrDefault("kafkaConfig", "default");
        KafkaConfigService service = (KafkaConfigService)Framework.getService(KafkaConfigService.class);
        return new KafkaLogManager(service.getTopicPrefix(kafkaConfig), service.getProducerProperties(kafkaConfig), service.getConsumerProperties(kafkaConfig));
    }

    protected org.nuxeo.lib.stream.log.LogManager createChronicleLogManager(LogConfigDescriptor config) {
        String basePath = config.options.getOrDefault("basePath", null);
        String directory = config.options.getOrDefault("directory", config.getId());
        Path path = this.getChroniclePath(basePath, directory);
        String retention = this.getChronicleRetention(config.options.getOrDefault("retention", null));
        return new ChronicleLogManager(path, retention);
    }

    protected String getChronicleRetention(String retention) {
        return retention != null ? retention : Framework.getProperty((String)NUXEO_STREAM_RET_DURATION_PROP, (String)"4d");
    }

    protected Path getChroniclePath(String basePath, String name) {
        if (basePath != null) {
            return Paths.get(basePath, name).toAbsolutePath();
        }
        basePath = Framework.getProperty((String)NUXEO_STREAM_DIR_PROP);
        if (basePath != null) {
            return Paths.get(basePath, name).toAbsolutePath();
        }
        basePath = Framework.getProperty((String)"nuxeo.data.dir");
        if (basePath != null) {
            return Paths.get(basePath, "stream", name).toAbsolutePath();
        }
        return Paths.get(Framework.getRuntime().getHome().getAbsolutePath(), "data", "stream", name).toAbsolutePath();
    }

    protected void createLogIfNotExists(LogConfigDescriptor config) {
        if (!config.isEnabled() || config.logs.isEmpty()) {
            return;
        }
        org.nuxeo.lib.stream.log.LogManager manager = this.getLogManager(config.getId());
        config.logs.forEach(l -> {
            log.info("Create if not exists stream: {} with manager: {}", (Object)l.getId(), (Object)config.getId());
            manager.createIfNotExists(l.getId(), l.size.intValue());
        });
    }

    public void start(ComponentContext context) {
        super.start(context);
        List logDescs = this.getDescriptors(XP_LOG_CONFIG);
        logDescs.forEach(this::createLogIfNotExists);
        List streamDescs = this.getDescriptors(XP_STREAM_PROCESSOR);
        streamDescs.forEach(this::initProcessor);
        new ComponentsLifeCycleListener().install();
    }

    protected void initProcessor(StreamProcessorDescriptor descriptor) {
        Topology topology;
        if (!descriptor.isEnabled()) {
            log.info("Processor {} disabled", (Object)descriptor.getId());
            return;
        }
        if (this.processors.containsKey(descriptor.getId())) {
            log.error("Processor already initialized: {}", (Object)descriptor.getId());
            return;
        }
        log.info("Init Stream processor: {} with manager: {}", (Object)descriptor.getId(), (Object)descriptor.config);
        this.getLogManager(descriptor.config);
        StreamManager streamManager = this.getStreamManager(descriptor.config);
        try {
            topology = descriptor.klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).getTopology(descriptor.options);
        }
        catch (ReflectiveOperationException e) {
            throw new StreamRuntimeException("Can not create topology for processor: " + descriptor.getId(), (Throwable)e);
        }
        Settings settings = this.getSettings(descriptor);
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = descriptor::getId;
        supplierArray[1] = () -> topology.toPlantuml(settings);
        log.debug("Starting computation topology: {}\n{}", supplierArray);
        if (descriptor.isStart()) {
            StreamProcessor streamProcessor = streamManager.registerAndCreateProcessor(descriptor.getId(), topology, settings);
            this.processors.put(descriptor.getId(), streamProcessor);
        } else {
            streamManager.register(descriptor.getId(), topology, settings);
            this.processors.put(descriptor.getId(), null);
        }
    }

    protected Settings getSettings(StreamProcessorDescriptor descriptor) {
        CodecService codecService = (CodecService)Framework.getService(CodecService.class);
        Codec<Record> actualCodec = descriptor.defaultCodec == null ? codecService.getCodec(DEFAULT_CODEC, Record.class) : codecService.getCodec(descriptor.defaultCodec, Record.class);
        Settings settings = new Settings(descriptor.defaultConcurrency.intValue(), descriptor.defaultPartitions.intValue(), actualCodec, descriptor.getDefaultPolicy(), null, descriptor.defaultExternal);
        descriptor.computations.forEach(comp -> settings.setConcurrency(comp.name, comp.concurrency.intValue()));
        descriptor.policies.forEach(policy -> settings.setPolicy(policy.name, descriptor.getPolicy(policy.name)));
        for (StreamProcessorDescriptor.StreamDescriptor streamDescriptor : descriptor.streams) {
            settings.setPartitions(streamDescriptor.name, (streamDescriptor.partitions != null ? streamDescriptor.partitions : descriptor.defaultPartitions).intValue());
            if (streamDescriptor.codec != null) {
                settings.setCodec(streamDescriptor.name, codecService.getCodec(streamDescriptor.codec, Record.class));
            }
            streamDescriptor.filters.forEach(filter -> settings.addFilter(streamDescriptor.name, filter.getFilter()));
            settings.setExternal(streamDescriptor.name, streamDescriptor.external != null ? streamDescriptor.external : descriptor.defaultExternal);
        }
        return settings;
    }

    public void stop(ComponentContext context) throws InterruptedException {
        super.stop(context);
        this.stopComputations();
        this.closeLogManagers();
    }

    protected void startComputations() {
        this.getDescriptors(XP_STREAM_PROCESSOR).forEach(d -> {
            StreamProcessor processor = this.processors.get(d.getId());
            if (processor != null) {
                processor.start();
            }
        });
    }

    protected void stopComputations() {
        this.processors.forEach((name, processor) -> {
            if (processor != null) {
                processor.stop(Duration.ofSeconds(1L));
            }
        });
        this.processors.clear();
    }

    protected void closeLogManagers() {
        this.logManagers.values().stream().filter(Objects::nonNull).forEach(org.nuxeo.lib.stream.log.LogManager::close);
        this.logManagers.clear();
    }

    protected class ComponentsLifeCycleListener
    implements ComponentManager.Listener {
        protected ComponentsLifeCycleListener() {
        }

        public void afterStart(ComponentManager mgr, boolean isResume) {
            StreamServiceImpl.this.startComputations();
        }

        public void beforeStop(ComponentManager mgr, boolean isStandby) {
            StreamServiceImpl.this.stopComputations();
            Framework.getRuntime().getComponentManager().removeListener((ComponentManager.Listener)this);
        }
    }
}

