/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test.runner;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.filter.ThresholdFilter;
import org.nuxeo.runtime.test.runner.RunnerFeature;

public class LogFeature
implements RunnerFeature {
    protected static final String CONSOLE_APPENDER = "CONSOLE";
    protected static final String CONSOLE_LOG_FEATURE_APPENDER = "CONSOLE_LOG_FEATURE";
    protected ConsoleAppender consoleAppender;
    protected ConsoleAppender hiddenAppender;

    public void hideWarningFromConsoleLog() {
        this.setConsoleLogThreshold(Level.ERROR.toString());
    }

    public void hideErrorFromConsoleLog() {
        this.setConsoleLogThreshold(Level.FATAL.toString());
    }

    public void setConsoleLogThreshold(String level) {
        if (this.consoleAppender != null) {
            return;
        }
        Logger rootLogger = LoggerContext.getContext((boolean)false).getRootLogger();
        this.consoleAppender = (ConsoleAppender)rootLogger.getAppenders().get(CONSOLE_APPENDER);
        rootLogger.removeAppender((Appender)this.consoleAppender);
        ConsoleAppender newAppender = ((ConsoleAppender.Builder)((ConsoleAppender.Builder)ConsoleAppender.newBuilder().withName(CONSOLE_LOG_FEATURE_APPENDER)).setTarget(ConsoleAppender.Target.SYSTEM_OUT).withFilter((Filter)ThresholdFilter.createFilter((Level)Level.toLevel((String)level), null, null))).build();
        newAppender.start();
        rootLogger.addAppender((Appender)newAppender);
        this.hiddenAppender = newAppender;
    }

    public void restoreConsoleLog() {
        if (this.consoleAppender == null) {
            return;
        }
        Logger rootLogger = LoggerContext.getContext((boolean)false).getRootLogger();
        rootLogger.removeAppender((Appender)this.hiddenAppender);
        rootLogger.addAppender((Appender)this.consoleAppender);
        this.consoleAppender = null;
        this.hiddenAppender = null;
    }
}

