/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test.runner;

import com.google.inject.Binder;
import org.apache.logging.log4j.ThreadContext;
import org.junit.runners.model.FrameworkMethod;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.RunnerFeature;

public class MDCFeature
implements RunnerFeature {
    protected static final String F_TEST = "fTest";
    protected static final String F_SUITE = "fSuite";
    protected static final String F_STATE = "fState";

    @Override
    public void initialize(FeaturesRunner runner) {
        ThreadContext.put((String)F_STATE, (String)"initialize");
    }

    @Override
    public void configure(FeaturesRunner runner, Binder binder) {
        ThreadContext.put((String)F_STATE, (String)"configure");
    }

    @Override
    public void beforeRun(FeaturesRunner runner) {
        ThreadContext.put((String)F_STATE, (String)"beforeRun");
    }

    @Override
    public void afterRun(FeaturesRunner runner) {
        ThreadContext.put((String)F_STATE, (String)"afterRun");
    }

    @Override
    public void start(FeaturesRunner runner) {
        ThreadContext.put((String)F_STATE, (String)"start");
    }

    @Override
    public void testCreated(Object test) {
        ThreadContext.put((String)F_STATE, (String)"testCreated");
        ThreadContext.put((String)F_SUITE, (String)test.getClass().getName());
    }

    @Override
    public void stop(FeaturesRunner runner) {
        ThreadContext.remove((String)F_STATE);
        ThreadContext.remove((String)F_SUITE);
        ThreadContext.remove((String)F_TEST);
    }

    @Override
    public void beforeSetup(FeaturesRunner runner) {
        ThreadContext.put((String)F_STATE, (String)"beforeSetup");
    }

    @Override
    public void afterTeardown(FeaturesRunner runner) {
        ThreadContext.put((String)F_STATE, (String)"afterTeardown");
    }

    @Override
    public void beforeMethodRun(FeaturesRunner runner, FrameworkMethod method, Object test) {
        ThreadContext.put((String)F_STATE, (String)"beforeMethodRun");
        ThreadContext.put((String)F_TEST, (String)method.getMethod().getName());
    }

    @Override
    public void afterMethodRun(FeaturesRunner runner, FrameworkMethod method, Object test) {
        ThreadContext.put((String)F_STATE, (String)"afterMethodRun");
        ThreadContext.remove((String)F_TEST);
    }
}

