/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test.runner;

import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.nuxeo.osgi.BundleImpl;
import org.nuxeo.runtime.model.ComponentManager;
import org.nuxeo.runtime.model.RuntimeContext;
import org.nuxeo.runtime.osgi.OSGiRuntimeService;
import org.nuxeo.runtime.test.runner.AnnotationScanner;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Deploys;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;
import org.nuxeo.runtime.test.runner.PartialDeploy;
import org.nuxeo.runtime.test.runner.RunnerFeature;
import org.nuxeo.runtime.test.runner.RuntimeFeature;
import org.nuxeo.runtime.test.runner.RuntimeHarness;
import org.nuxeo.runtime.test.runner.TargetExtensions;
import org.osgi.framework.Bundle;

public class RuntimeDeployment {
    Set<String> bundles = new HashSet<String>();
    Map<String, Set<TargetExtensions>> partialBundles = new HashMap<String, Set<TargetExtensions>>();
    Map<String, Collection<String>> mainContribs = new HashMap<String, Collection<String>>();
    SetMultimap<String, String> mainIndex = Multimaps.newSetMultimap(this.mainContribs, LinkedHashSet::new);
    @Deprecated
    Map<String, Collection<String>> localContribs = new HashMap<String, Collection<String>>();
    @Deprecated
    SetMultimap<String, String> localIndex = Multimaps.newSetMultimap(this.localContribs, LinkedHashSet::new);
    @Deprecated
    protected LinkedList<RuntimeContext> contexts = new LinkedList();

    protected void index(Class<?> clazz) {
        AnnotationScanner scanner = FeaturesRunner.scanner;
        scanner.scan(clazz);
        List<? extends Annotation> annos = scanner.getAnnotations(clazz);
        if (annos == null) {
            return;
        }
        for (Annotation annotation : annos) {
            if (annotation.annotationType() == Deploy.class) {
                this.index((Deploy)annotation);
                continue;
            }
            if (annotation.annotationType() == Deploys.class) {
                this.index((Deploys)annotation);
                continue;
            }
            if (annotation.annotationType() == LocalDeploy.class) {
                this.index((LocalDeploy)annotation);
                continue;
            }
            if (annotation.annotationType() != PartialDeploy.class) continue;
            this.index((PartialDeploy)annotation);
        }
    }

    protected void index(RunnerFeature feature) {
        this.index(feature.getClass());
    }

    protected void index(Method method) {
        this.index(method.getAnnotation(Deploy.class));
        this.index(method.getAnnotation(Deploys.class));
        this.index(method.getAnnotation(LocalDeploy.class));
    }

    protected void index(Deploy config) {
        if (config == null) {
            return;
        }
        for (String each : config.value()) {
            this.index(each, this.mainIndex);
        }
    }

    private void index(Deploys deploys) {
        if (deploys == null) {
            return;
        }
        for (Deploy value : deploys.value()) {
            this.index(value);
        }
    }

    @Deprecated
    protected void index(LocalDeploy config) {
        if (config == null) {
            return;
        }
        for (String each : config.value()) {
            this.index(each, this.localIndex);
        }
    }

    protected void index(PartialDeploy config) {
        if (config == null) {
            return;
        }
        Set pairs = this.partialBundles.computeIfAbsent(config.bundle(), key -> new HashSet());
        Arrays.stream(config.extensions()).map(c -> {
            try {
                return (TargetExtensions)c.newInstance();
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException(e);
            }
        }).forEach(pairs::add);
    }

    protected void index(Features features) {
        for (Class<? extends RunnerFeature> each : features.value()) {
            this.index(each);
        }
    }

    protected void index(String directive, SetMultimap<String, String> contribs) {
        int sepIndex = directive.indexOf(58);
        if (sepIndex == -1) {
            this.bundles.add(directive);
        } else {
            String bundle = directive.substring(0, sepIndex);
            String resource = directive.substring(sepIndex + 1);
            contribs.put((Object)bundle, (Object)resource);
        }
    }

    protected void deploy(FeaturesRunner runner, RuntimeHarness harness) {
        AssertionError errors = new AssertionError((Object)"deployment errors");
        OSGiRuntimeService runtime = (OSGiRuntimeService)harness.getContext().getRuntime();
        for (String string : this.bundles) {
            BundleImpl bundle = harness.getOSGiAdapter().getBundle(string);
            if (bundle == null) {
                try {
                    harness.deployBundle(string);
                    bundle = harness.getOSGiAdapter().getBundle(string);
                    if (bundle == null) {
                        throw new UnsupportedOperationException("Should not occur");
                    }
                }
                catch (Exception error) {
                    ((Throwable)((Object)errors)).addSuppressed(error);
                    continue;
                }
                this.contexts.add(runtime.getContext((Bundle)bundle));
            }
            try {
                for (String resource : this.mainIndex.removeAll((Object)string)) {
                    try {
                        harness.deployContrib(string, resource);
                    }
                    catch (Exception error) {
                        ((Throwable)((Object)errors)).addSuppressed(error);
                    }
                }
                for (String resource : this.localIndex.removeAll((Object)string)) {
                    URL url = runner.getTargetTestResource(resource);
                    if (url == null) {
                        url = bundle.getEntry(resource);
                    }
                    if (url == null) {
                        url = runner.getTargetTestClass().getClassLoader().getResource(resource);
                    }
                    if (url == null) {
                        throw new AssertionError((Object)("Cannot find " + resource + " in " + string));
                    }
                    this.contexts.add(harness.deployTestContrib(string, url));
                }
            }
            catch (Exception error) {
                ((Throwable)((Object)errors)).addSuppressed(error);
            }
        }
        for (Map.Entry entry : this.mainIndex.entries()) {
            try {
                harness.deployContrib((String)entry.getKey(), (String)entry.getValue());
            }
            catch (Exception error) {
                ((Throwable)((Object)errors)).addSuppressed(error);
            }
        }
        for (Map.Entry entry : this.localIndex.entries()) {
            try {
                this.contexts.add(harness.deployTestContrib((String)entry.getKey(), (String)entry.getValue()));
            }
            catch (Exception error) {
                ((Throwable)((Object)errors)).addSuppressed(error);
            }
        }
        for (Map.Entry entry : this.partialBundles.entrySet()) {
            try {
                this.contexts.add(harness.deployPartial((String)entry.getKey(), (Set)entry.getValue()));
            }
            catch (Exception e) {
                ((Throwable)((Object)errors)).addSuppressed(e);
            }
        }
        if (((Throwable)((Object)errors)).getSuppressed().length > 0) {
            throw errors;
        }
    }

    public static RuntimeDeployment onTest(FeaturesRunner runner) {
        RuntimeDeployment deployment = new RuntimeDeployment();
        deployment.index(runner.getDescription().getTestClass());
        for (RunnerFeature each : runner.getFeatures()) {
            deployment.index(each);
        }
        return deployment;
    }

    public static MethodRule onMethod() {
        return new OnMethod();
    }

    protected Statement onStatement(FeaturesRunner runner, RuntimeHarness harness, FrameworkMethod method, Statement base) {
        return new DeploymentStatement(runner, harness, method, base);
    }

    protected class DeploymentStatement
    extends Statement {
        protected final FeaturesRunner runner;
        protected final RuntimeHarness harness;
        protected final FrameworkMethod method;
        protected final Statement base;

        protected DeploymentStatement(FeaturesRunner runner, RuntimeHarness harness, FrameworkMethod method, Statement base) {
            this.runner = runner;
            this.harness = harness;
            this.method = method;
            this.base = base;
        }

        protected void tryDeploy() {
            ComponentManager mgr = this.harness.getContext().getRuntime().getComponentManager();
            if (mgr.hasChanged()) {
                mgr.reset();
            }
            RuntimeDeployment.this.deploy(this.runner, this.harness);
            mgr.refresh(true);
            mgr.start();
        }

        public void evaluate() throws Throwable {
            this.tryDeploy();
            this.base.evaluate();
        }
    }

    protected static class OnMethod
    implements MethodRule {
        @Inject
        protected FeaturesRunner runner;

        protected OnMethod() {
        }

        public Statement apply(Statement base, FrameworkMethod method, Object target) {
            RuntimeDeployment deployment = new RuntimeDeployment();
            deployment.index(method.getMethod());
            return deployment.onStatement(this.runner, this.runner.getFeature(RuntimeFeature.class).harness, method, base);
        }
    }
}

