/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test.runner;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.ServerSocket;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.RunnerFeature;
import org.nuxeo.runtime.test.runner.RuntimeFeature;
import org.nuxeo.runtime.test.runner.ServletContainer;
import sun.net.www.http.HttpClient;

@Deploy(value={"org.nuxeo.runtime.server"})
@Features(value={RuntimeFeature.class})
public class ServletContainerFeature
implements RunnerFeature {
    private static final Logger log = LogManager.getLogger(ServletContainerFeature.class);
    protected static final int RETRIES = 1000;
    protected int port;

    @Override
    public void initialize(FeaturesRunner runner) throws Exception {
        int port;
        ServletContainerFeature.disableSunHttpClientRetryPostProp();
        ServletContainer conf = runner.getConfig(ServletContainer.class);
        int n = port = conf == null ? 0 : conf.port();
        if (port <= 0) {
            port = this.findFreePort();
        }
        this.port = port;
        System.setProperty("nuxeo.servlet-container.port", String.valueOf(port));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int findFreePort() {
        int i = 0;
        while (i < 1000) {
            try (ServerSocket socket = new ServerSocket(0);){
                socket.setReuseAddress(true);
                int n = socket.getLocalPort();
                return n;
            }
            catch (IOException e) {
                log.trace("Failed to allocate port", (Throwable)e);
                ++i;
            }
        }
        throw new RuntimeException("Unable to find free port after 1000 retries");
    }

    public int getPort() {
        return this.port;
    }

    public static void disableSunHttpClientRetryPostProp() throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field field = HttpClient.class.getDeclaredField("retryPostProp");
        field.setAccessible(true);
        field.setBoolean(null, false);
    }
}

