/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test.runner;

import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.management.jvm.ThreadDeadlocksDetector;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Deploys;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.HotDeployer;
import org.nuxeo.runtime.test.runner.RunnerFeature;
import org.nuxeo.runtime.test.runner.RuntimeFeature;
import org.nuxeo.runtime.test.runner.TransactionalConfig;
import org.nuxeo.runtime.transaction.TransactionHelper;

@Deploys(value={@Deploy(value={"org.nuxeo.runtime.jtajca"}), @Deploy(value={"org.nuxeo.runtime.datasource"})})
@Features(value={RuntimeFeature.class})
public class TransactionalFeature
implements RunnerFeature {
    private static final Log log = LogFactory.getLog(TransactionalFeature.class);
    protected boolean autoStartTransaction;
    protected boolean txStarted;
    protected final List<Waiter> waiters = new LinkedList<Waiter>();

    public void addWaiter(Waiter waiter) {
        this.waiters.add(waiter);
    }

    public void nextTransaction() {
        this.nextTransaction(Duration.ofMinutes(3L));
    }

    @Deprecated
    public void nextTransaction(long duration, TimeUnit unit) {
        this.nextTransaction(Duration.ofMillis(unit.toMillis(duration)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextTransaction(Duration duration) {
        boolean tx = TransactionHelper.isTransactionActive();
        boolean rb = TransactionHelper.isTransactionMarkedRollback();
        if (tx || rb) {
            TransactionHelper.commitOrRollbackTransaction();
        }
        try {
            Duration remainingDuration = duration;
            for (Waiter provider : this.waiters) {
                long start = System.currentTimeMillis();
                try {
                    this.await(provider, remainingDuration);
                }
                catch (InterruptedException cause) {
                    Thread.currentThread().interrupt();
                    throw new AssertionError("interrupted while awaiting for asynch completion", cause);
                }
                long end = System.currentTimeMillis();
                remainingDuration = remainingDuration.minusMillis(end - start);
            }
        }
        finally {
            if (tx || rb) {
                TransactionHelper.startTransaction();
                if (rb) {
                    TransactionHelper.setTransactionRollbackOnly();
                }
            }
        }
    }

    protected void await(Waiter waiter, Duration duration) throws InterruptedException {
        if (!waiter.await(duration)) {
            try {
                File file = new ThreadDeadlocksDetector().dump(new long[0]);
                log.warn((Object)("timed out in " + waiter.getClass() + ", thread dump available in " + file));
            }
            catch (IOException cause) {
                log.warn((Object)("timed out in " + waiter.getClass() + ", cannot take thread dump"), (Throwable)cause);
            }
        }
    }

    @Override
    public void initialize(FeaturesRunner runner) {
        this.autoStartTransaction = runner.getConfig(TransactionalConfig.class).autoStart();
        runner.getFeature(RuntimeFeature.class).registerHandler(new TransactionalDeployer());
    }

    @Override
    public void beforeSetup(FeaturesRunner runner) {
        this.startTransactionBefore();
    }

    @Override
    public void afterTeardown(FeaturesRunner runner) {
        this.commitOrRollbackTransactionAfter();
    }

    protected void startTransactionBefore() {
        if (this.autoStartTransaction) {
            this.txStarted = TransactionHelper.startTransaction();
        }
    }

    protected void commitOrRollbackTransactionAfter() {
        if (this.txStarted) {
            TransactionHelper.commitOrRollbackTransaction();
        } else if (TransactionHelper.isTransactionActive()) {
            try {
                TransactionHelper.setTransactionRollbackOnly();
                TransactionHelper.commitOrRollbackTransaction();
            }
            finally {
                log.warn((Object)"Committing a transaction for your, please do it yourself");
            }
        }
    }

    public class TransactionalDeployer
    extends HotDeployer.ActionHandler {
        @Override
        public void exec(String action, String ... args) throws Exception {
            TransactionalFeature.this.commitOrRollbackTransactionAfter();
            this.next.exec(action, args);
            TransactionalFeature.this.startTransactionBefore();
        }
    }

    @FunctionalInterface
    public static interface Waiter {
        @Deprecated
        default public boolean await(long deadline) throws InterruptedException {
            return this.await(Duration.ofMillis(deadline - System.currentTimeMillis()));
        }

        public boolean await(Duration var1) throws InterruptedException;
    }
}

