/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test.runner.web;

import com.google.inject.Binder;
import com.google.inject.Scopes;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.RunnerFeature;
import org.nuxeo.runtime.test.runner.ServletContainerFeature;
import org.nuxeo.runtime.test.runner.web.Browser;
import org.nuxeo.runtime.test.runner.web.BrowserFamily;
import org.nuxeo.runtime.test.runner.web.Configuration;
import org.nuxeo.runtime.test.runner.web.DriverFactory;
import org.nuxeo.runtime.test.runner.web.HomePage;
import org.nuxeo.runtime.test.runner.web.SkipBrowser;
import org.nuxeo.runtime.test.runner.web.WebPage;
import org.openqa.selenium.WebDriver;

public class WebDriverFeature
implements RunnerFeature {
    private static final Log log = LogFactory.getLog(WebDriverFeature.class);
    protected Browser browser;
    protected HomePage homepage;
    protected Configuration config;
    protected Class<? extends WebPage> home;

    @Override
    public void initialize(FeaturesRunner runner) throws Exception {
        this.browser = runner.getConfig(Browser.class);
        this.homepage = runner.getConfig(HomePage.class);
        String fcName = System.getProperty(DriverFactory.class.getName());
        DriverFactory factory = fcName != null ? (DriverFactory)Class.forName(fcName).newInstance() : (this.browser.factory() != DriverFactory.class ? this.browser.factory().newInstance() : this.browser.type().getDriverFactory());
        this.config = new Configuration(factory);
        this.config.setHomePageClass(this.homepage.type());
        String url = System.getProperty(HomePage.class.getName() + ".url");
        if (url == null) {
            url = this.homepage.url();
        }
        this.config.setHome(url);
        try {
            runner.filter(new Filter(){

                public boolean shouldRun(Description description) {
                    SkipBrowser skip = (SkipBrowser)description.getAnnotation(SkipBrowser.class);
                    if (skip == null) {
                        return true;
                    }
                    for (BrowserFamily family : skip.value()) {
                        if (!WebDriverFeature.this.config.getBrowserFamily().equals((Object)family)) continue;
                        return false;
                    }
                    return true;
                }

                public String describe() {
                    return "Filtering tests according to current browser settings";
                }
            });
        }
        catch (ClassCastException classCastException) {
        }
        catch (NoTestsRemainException e) {
            log.error((Object)e.toString(), (Throwable)e);
        }
    }

    @Override
    public void configure(FeaturesRunner runner, Binder binder) {
        int port = runner.getFeature(ServletContainerFeature.class).getPort();
        this.config.setPort(port);
        binder.bind(Configuration.class).toInstance((Object)this.config);
        binder.bind(WebDriver.class).toProvider(() -> this.config.getDriver());
        if (this.config.getHomePageClass() != null) {
            binder.bind(this.config.getHomePageClass()).toProvider(() -> WebPage.getPage(runner, this.config, this.config.getHomePageClass())).in(Scopes.SINGLETON);
        }
    }

    @Override
    public void stop(FeaturesRunner runner) {
        this.config.resetDriver();
        WebPage.flushPageCache();
    }
}

