/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.runner.RunWith;
import org.nuxeo.runtime.RuntimeServiceException;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.osgi.OSGiRuntimeService;
import org.nuxeo.runtime.test.RuntimeHarnessImpl;
import org.nuxeo.runtime.test.runner.ConditionalIgnoreRule;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.MDCFeature;
import org.nuxeo.runtime.test.runner.RandomBug;

@RunWith(value=FeaturesRunner.class)
@Features(value={MDCFeature.class, ConditionalIgnoreRule.Feature.class, RandomBug.Feature.class})
@Ignore
@Deprecated
public class NXRuntimeTestCase
extends RuntimeHarnessImpl {
    protected Mockery jmcontext = new JUnit4Mockery();
    private static final Log log;
    protected boolean restart = false;
    protected List<String[]> deploymentStack = new ArrayList<String[]>();
    protected final boolean isTestUnit;

    public NXRuntimeTestCase() {
        this.isTestUnit = true;
    }

    public NXRuntimeTestCase(Class<?> clazz) {
        super(clazz);
        this.isTestUnit = false;
    }

    @Override
    public void restart() throws Exception {
        this.restart = true;
        try {
            this.tearDown();
            this.setUp();
        }
        finally {
            this.restart = false;
        }
    }

    @Override
    public void start() throws Exception {
        this.startRuntime();
    }

    @Before
    public void startRuntime() throws Exception {
        System.setProperty("org.nuxeo.runtime.testing", "true");
        this.wipeRuntime();
        this.initUrls();
        if (this.urls == null) {
            throw new UnsupportedOperationException("no bundles available");
        }
        this.initOsgiRuntime();
        this.setUp();
        if (this.isTestUnit) {
            this.fireFrameworkStarted();
        }
        this.postSetUp();
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
        this.deploymentStack = new ArrayList<String[]>();
    }

    protected void postSetUp() throws Exception {
    }

    @After
    public void stopRuntime() throws Exception {
        this.tearDown();
        this.wipeRuntime();
        if (this.workingDir != null && !this.restart) {
            if (this.workingDir.exists() && !FileUtils.deleteQuietly((File)this.workingDir)) {
                log.warn((Object)("Cannot delete " + this.workingDir));
            }
            this.workingDir = null;
        }
        this.readUris = null;
        this.bundles = null;
    }

    @Override
    public void stop() throws Exception {
        this.stopRuntime();
    }

    protected OSGiRuntimeService handleNewRuntime(OSGiRuntimeService aRuntime) {
        return aRuntime;
    }

    public static URL[] introspectClasspath(ClassLoader loader) {
        return (URL[])new FastClasspathScanner(new String[0]).getUniqueClasspathElements().stream().map(file -> {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException cause) {
                throw new Error("Could not get URL from " + file, cause);
            }
        }).toArray(URL[]::new);
    }

    public static URL getResource(String name) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        String callerName = Thread.currentThread().getStackTrace()[2].getClassName();
        String relativePath = callerName.replace('.', '/').concat(".class");
        String fullPath = loader.getResource(relativePath).getPath();
        String basePath = fullPath.substring(0, fullPath.indexOf(relativePath));
        try {
            Enumeration<URL> resources = loader.getResources(name);
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                if (!resource.getPath().startsWith(basePath)) continue;
                return resource;
            }
        }
        catch (IOException e) {
            return null;
        }
        return loader.getResource(name);
    }

    protected void deployContrib(URL url) {
        Assert.assertEquals((Object)this.runtime, (Object)Framework.getRuntime());
        log.info((Object)("Deploying contribution from " + url.toString()));
        try {
            this.runtime.getContext().deploy(url);
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to deploy contrib " + url.toString()));
        }
    }

    public void deployContrib(String uri) throws Exception {
        int i = uri.indexOf(58);
        if (i == -1) {
            throw new IllegalArgumentException("Invalid deployment URI: " + uri + ". Must be of the form bundleSymbolicName:pathInBundleJar");
        }
        this.deployContrib(uri.substring(0, i), uri.substring(i + 1));
    }

    public void undeployContrib(String uri) throws Exception {
        int i = uri.indexOf(58);
        if (i == -1) {
            throw new IllegalArgumentException("Invalid deployment URI: " + uri + ". Must be of the form bundleSymbolicName:pathInBundleJar");
        }
        this.undeployContrib(uri.substring(0, i), uri.substring(i + 1));
    }

    protected static boolean isVersionSuffix(String s) {
        if (s.length() == 0) {
            return true;
        }
        return s.matches("-(\\d+\\.?)+(-SNAPSHOT)?(\\.\\w+)?");
    }

    protected URL lookupBundleUrl(String bundle) {
        for (URL url : this.urls) {
            String[] pathElts = url.getPath().split("/");
            for (int i = 0; i < pathElts.length; ++i) {
                if (!pathElts[i].startsWith(bundle) || !NXRuntimeTestCase.isVersionSuffix(pathElts[i].substring(bundle.length()))) continue;
                boolean isTestVersion = false;
                for (int j = i + 1; j < pathElts.length; ++j) {
                    if (!pathElts[j].startsWith("test")) continue;
                    isTestVersion = true;
                    break;
                }
                if (isTestVersion) continue;
                log.info((Object)("Resolved " + bundle + " as " + url.toString()));
                return url;
            }
        }
        throw new RuntimeServiceException("Could not resolve bundle " + bundle);
    }

    protected void applyInlineDeployments() throws Exception {
        this.runtime.getComponentManager().refresh(false);
        this.runtime.getComponentManager().start();
        this.postSetUp();
    }

    protected void removeInlineDeployments() throws Exception {
        this.runtime.getComponentManager().reset();
        this.runtime.getComponentManager().start();
        this.postSetUp();
    }

    public void pushInlineDeployments(String ... deploymentUris) throws Exception {
        this.deploymentStack.add(deploymentUris);
        for (String uri : deploymentUris) {
            this.deployContrib(uri);
        }
        this.applyInlineDeployments();
    }

    public void popInlineDeployments() throws Exception {
        if (this.deploymentStack.isEmpty()) {
            throw new IllegalStateException("deployment stack is empty");
        }
        this.popInlineDeployments(this.deploymentStack.size() - 1);
    }

    public void popInlineDeployments(int index) throws Exception {
        if (index < 0 || index > this.deploymentStack.size() - 1) {
            throw new IllegalStateException("deployment stack index is invalid: " + index);
        }
        this.deploymentStack.remove(index);
        this.runtime.getComponentManager().reset();
        for (String[] ar : this.deploymentStack) {
            for (String element : ar) {
                this.deployContrib(element);
            }
        }
        this.applyInlineDeployments();
    }

    static {
        System.setProperty("org.nuxeo.runtime.redirectJUL", "false");
        log = LogFactory.getLog(NXRuntimeTestCase.class);
    }
}

