/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test.runner;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.inject.Inject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.ThreadContext;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.internal.AssumptionViolatedException;
import org.junit.rules.MethodRule;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.RunnerFeature;

public class RandomBug {
    private static final Log log = LogFactory.getLog(RandomBug.class);
    protected static final RandomBug self = new RandomBug();
    public static final String MODE_PROPERTY = "nuxeo.tests.random.mode";
    public final Mode DEFAULT = Mode.RELAX;

    protected RepeatRule onTest() {
        return new RepeatRule();
    }

    protected RepeatRule onMethod() {
        return new RepeatRule();
    }

    protected Mode fetchMode() {
        String mode = System.getProperty(MODE_PROPERTY, this.DEFAULT.name());
        return Mode.valueOf(mode.toUpperCase());
    }

    protected RepeatStatement onRepeat(Repeat someParams, RunNotifier aNotifier, Statement aStatement, Description description) {
        if (someParams.bypass()) {
            return new Bypass(someParams, aNotifier, aStatement, description);
        }
        switch (this.fetchMode()) {
            case BYPASS: {
                return new Bypass(someParams, aNotifier, aStatement, description);
            }
            case STRICT: {
                return new RepeatOnSuccess(someParams, aNotifier, aStatement, description);
            }
            case RELAX: {
                return new RepeatOnFailure(someParams, aNotifier, aStatement, description);
            }
        }
        throw new IllegalArgumentException("no such mode");
    }

    protected class Bypass
    extends RepeatStatement {
        public Bypass(Repeat someParams, RunNotifier aNotifier, Statement aStatement, Description description) {
            super(someParams, aNotifier, aStatement, description);
        }

        @Override
        public void evaluate() {
            this.notifier.fireTestIgnored(this.description);
        }

        @Override
        protected Error error() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected int retryCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected boolean returnOnSuccess() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected boolean returnOnFailure() {
            return false;
        }
    }

    protected class RepeatOnSuccess
    extends RepeatStatement {
        protected RepeatOnSuccess(Repeat someParams, RunNotifier aNotifier, Statement aStatement, Description description) {
            super(someParams, aNotifier, aStatement, description);
        }

        @Override
        protected Error error() {
            return new AssertionError((Object)String.format("No failure after %d tries. Either the bug is fixed or you should increase the 'onSuccess' value.\nIssue: %s", this.params.onSuccess(), this.params.issue()));
        }

        @Override
        protected boolean returnOnFailure() {
            return true;
        }

        @Override
        protected boolean returnOnSuccess() {
            return false;
        }

        @Override
        protected int retryCount() {
            return this.params.onSuccess();
        }
    }

    protected class RepeatOnFailure
    extends RepeatStatement {
        protected String issue;

        protected RepeatOnFailure(Repeat someParams, RunNotifier aNotifier, Statement aStatement, Description description) {
            super(someParams, aNotifier, aStatement, description);
        }

        @Override
        protected Error error() {
            return new AssertionError((Object)String.format("No success after %d tries. Either the bug is not random or you should increase the 'onFailure' value.\nIssue: %s", this.params.onFailure(), this.issue));
        }

        @Override
        protected int retryCount() {
            return this.params.onFailure();
        }

        @Override
        protected boolean returnOnFailure() {
            return false;
        }

        @Override
        protected boolean returnOnSuccess() {
            return true;
        }
    }

    protected abstract class RepeatStatement
    extends Statement {
        protected final Repeat params;
        protected final RunNotifier notifier;
        protected boolean gotFailure;
        protected final RunListener listener = new RunListener(){

            public void testStarted(Description desc) {
                log.debug((Object)(RepeatStatement.this.displayName(desc) + " STARTED"));
            }

            public void testFailure(Failure failure) {
                RepeatStatement.this.gotFailure = true;
                log.debug((Object)(RepeatStatement.this.displayName(failure.getDescription()) + " FAILURE"));
                log.trace((Object)failure, failure.getException());
            }

            public void testAssumptionFailure(Failure failure) {
                log.debug((Object)(RepeatStatement.this.displayName(failure.getDescription()) + " ASSUMPTION FAILURE"));
                log.trace((Object)failure, failure.getException());
            }

            public void testIgnored(Description desc) {
                log.debug((Object)(RepeatStatement.this.displayName(desc) + " IGNORED"));
            }

            public void testFinished(Description desc) {
                log.debug((Object)(RepeatStatement.this.displayName(desc) + " FINISHED"));
            }
        };
        protected final Statement base;
        protected int serial;
        protected Description description;

        protected RepeatStatement(Repeat someParams, RunNotifier aNotifier, Statement aStatement, Description aDescription) {
            this.params = someParams;
            this.notifier = aNotifier;
            this.base = aStatement;
            this.description = aDescription;
        }

        protected String displayName(Description desc) {
            Object displayName = desc.getClassName().substring(desc.getClassName().lastIndexOf(".") + 1);
            if (desc.isTest()) {
                displayName = (String)displayName + "." + desc.getMethodName();
            }
            return displayName;
        }

        protected void onEnter(int serial) {
            this.serial = serial;
            ThreadContext.put((String)"fRepeat", (String)Integer.toString(serial));
        }

        protected void onLeave() {
            ThreadContext.remove((String)"fRepeat");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void evaluate() {
            Error error = this.error();
            this.notifier.addListener(this.listener);
            try {
                log.debug((Object)(this.displayName(this.description) + " STARTED"));
                for (int retry = 1; retry <= this.retryCount(); ++retry) {
                    Throwable t;
                    this.gotFailure = false;
                    this.onEnter(retry);
                    try {
                        log.debug((Object)(this.displayName(this.description) + " retry " + retry));
                        this.base.evaluate();
                    }
                    catch (AssumptionViolatedException cause) {
                        t = new Throwable("On retry " + retry, cause);
                        error.addSuppressed(t);
                        this.notifier.fireTestAssumptionFailed(new Failure(this.description, t));
                    }
                    catch (Throwable cause) {
                        t = new Throwable("On retry " + retry, cause);
                        error.addSuppressed(t);
                        if (this.returnOnFailure()) {
                            this.notifier.fireTestFailure(new Failure(this.description, t));
                        } else {
                            this.gotFailure = true;
                            log.debug((Object)(this.displayName(this.description) + " FAILURE SWALLOW"));
                            log.trace((Object)t, t);
                        }
                    }
                    finally {
                        this.onLeave();
                    }
                    if (this.gotFailure && this.returnOnFailure()) {
                        log.debug((Object)(this.displayName(this.description) + " returnOnFailure"));
                        return;
                    }
                    if (this.gotFailure || !this.returnOnSuccess()) continue;
                    log.debug((Object)(this.displayName(this.description) + " returnOnSuccess"));
                    return;
                }
            }
            finally {
                log.debug((Object)(this.displayName(this.description) + " FINISHED"));
                this.notifier.removeListener(this.listener);
            }
            log.trace((Object)("throw " + error));
            throw error;
        }

        protected abstract Error error();

        protected abstract int retryCount();

        protected abstract boolean returnOnSuccess();

        protected abstract boolean returnOnFailure();
    }

    public static enum Mode {
        BYPASS,
        STRICT,
        RELAX;

    }

    public class RepeatRule
    implements TestRule,
    MethodRule {
        @Inject
        protected RunNotifier notifier;
        @Inject
        FeaturesRunner runner;
        public RepeatStatement statement;

        public Statement apply(Statement base, Description description) {
            Repeat actual = this.runner.getConfig(Repeat.class);
            if (actual.issue() == null) {
                return base;
            }
            this.statement = RandomBug.this.onRepeat(actual, this.notifier, base, description);
            return this.statement;
        }

        public Statement apply(Statement base, FrameworkMethod method, Object fixtureTarget) {
            Repeat actual = (Repeat)method.getAnnotation(Repeat.class);
            if (actual == null) {
                return base;
            }
            Class<?> fixtureType = fixtureTarget.getClass();
            Description description = Description.createTestDescription(fixtureType, (String)method.getName(), (Annotation[])method.getAnnotations());
            this.statement = RandomBug.this.onRepeat(actual, this.notifier, base, description);
            return this.statement;
        }
    }

    public static class Feature
    implements RunnerFeature {
        @ClassRule
        public static TestRule onClass() {
            return self.onTest();
        }

        @Rule
        public MethodRule onMethod() {
            return self.onMethod();
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Inherited
    public static @interface Repeat {
        public String issue();

        public int onSuccess() default 30;

        public int onFailure() default 10;

        public boolean bypass() default false;
    }
}

