/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test.runner;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.github.classgraph.ClassGraph;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nuxeo.runtime.test.runner.Defaults;

public class AnnotationScanner {
    protected final Set<Class<?>> visitedClasses = new HashSet();
    protected final Map<Class<?>, List<Annotation>> classes = new Hashtable();

    public synchronized void scan(Class<?> clazz) {
        if (this.classes.containsKey(clazz)) {
            return;
        }
        this.collectAnnotations(clazz);
    }

    public List<? extends Annotation> getAnnotations(Class<?> clazz) {
        if (!this.visitedClasses.contains(clazz)) {
            this.scan(clazz);
        }
        return this.classes.get(clazz);
    }

    public <T extends Annotation> T getAnnotation(Class<?> clazz, Class<T> annotationType) {
        List<T> annotations = this.getAnnotations(clazz, annotationType);
        if (annotations.isEmpty()) {
            return null;
        }
        return Defaults.of(annotationType, annotations);
    }

    public <T extends Annotation> T getFirstAnnotation(Class<?> clazz, Class<T> annotationType) {
        List<T> result = this.getAnnotations(clazz, annotationType);
        if (result.isEmpty()) {
            return null;
        }
        return (T)((Annotation)result.get(0));
    }

    public <T extends Annotation> List<T> getAnnotations(Class<?> clazz, Class<T> annotationType) {
        if (!this.visitedClasses.contains(clazz)) {
            this.scan(clazz);
        }
        return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)this.classes.get(clazz), (Predicate)Predicates.instanceOf(annotationType)));
    }

    protected List<Annotation> collectAnnotations(Class<?> clazz) {
        if (this.visitedClasses.contains(clazz)) {
            return this.classes.get(clazz);
        }
        this.visitedClasses.add(clazz);
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        try {
            Annotation[] data = clazz.getAnnotations();
            result.addAll(Arrays.asList(data));
        }
        catch (ArrayStoreException cause) {
            String classpathFiles = new ClassGraph().getClasspathFiles().toString();
            throw new AssertionError("Cannot load annotations of " + clazz.getName() + ", check your classpath for missing classes\n" + classpathFiles, cause);
        }
        for (Class<?> itf : clazz.getInterfaces()) {
            result.addAll(this.collectAnnotations(itf));
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            result.addAll(this.collectAnnotations(superClass));
        }
        this.classes.put(clazz, result);
        return result;
    }
}

