/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test.runner;

import com.google.inject.Module;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.junit.runners.model.TestClass;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.RunnerFeature;

class FeaturesLoader {
    private final FeaturesRunner runner;
    protected final Map<Class<? extends RunnerFeature>, Holder> index = new HashMap<Class<? extends RunnerFeature>, Holder>();
    protected final List<Holder> holders = new LinkedList<Holder>();

    FeaturesLoader(FeaturesRunner featuresRunner) {
        this.runner = featuresRunner;
    }

    Collection<Holder> holders() {
        return Collections.unmodifiableCollection(this.holders);
    }

    Collection<Holder> reversedHolders() {
        return this.reversed(this.holders);
    }

    Collection<RunnerFeature> features() {
        return this.holders.stream().map(h -> h.feature).collect(Collectors.toList());
    }

    protected <T> List<T> reversed(List<T> list) {
        ArrayList<T> reversed = new ArrayList<T>(list);
        Collections.reverse(reversed);
        return reversed;
    }

    protected boolean contains(Class<? extends RunnerFeature> aType) {
        return this.index.containsKey(aType);
    }

    public void loadFeatures(Class<?> classToRun) throws Exception {
        FeaturesRunner.scanner.scan(classToRun);
        List<Features> annos = FeaturesRunner.scanner.getAnnotations(classToRun, Features.class);
        if (annos != null) {
            for (Features anno : annos) {
                for (Class<? extends RunnerFeature> cl : anno.value()) {
                    this.loadFeature(new HashSet(), cl);
                }
            }
        }
    }

    protected void loadFeature(HashSet<Class<?>> cycles, Class<? extends RunnerFeature> clazz) throws Exception {
        if (this.index.containsKey(clazz)) {
            return;
        }
        if (cycles.contains(clazz)) {
            throw new IllegalStateException("Cycle detected in features dependencies of " + clazz);
        }
        cycles.add(clazz);
        FeaturesRunner.scanner.scan(clazz);
        List<Features> annos = FeaturesRunner.scanner.getAnnotations(clazz, Features.class);
        if (annos != null) {
            for (Features anno : annos) {
                for (Class<? extends RunnerFeature> cl : anno.value()) {
                    this.loadFeature(cycles, cl);
                }
            }
        }
        Holder actual = new Holder(clazz);
        this.holders.add(actual);
        this.index.put(clazz, actual);
    }

    public <T extends RunnerFeature> T getFeature(Class<T> aType) {
        if (!this.index.containsKey(aType)) {
            return null;
        }
        return (T)((RunnerFeature)aType.cast(this.index.get(aType).feature));
    }

    protected Module onModule() {
        return aBinder -> {
            for (Holder each : this.holders) {
                each.feature.configure(this.runner, aBinder);
                aBinder.bind(each.feature.getClass()).toInstance((Object)each.feature);
                aBinder.requestInjection((Object)each.feature);
            }
        };
    }

    protected static class Holder {
        protected final Class<? extends RunnerFeature> type;
        protected final TestClass testClass;
        protected RunnerFeature feature;

        Holder(Class<? extends RunnerFeature> aType) throws ReflectiveOperationException {
            this.type = aType;
            this.testClass = new TestClass(aType);
            this.feature = aType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }

        public String toString() {
            return "Holder [type=" + this.type + "]";
        }
    }
}

