/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test.runner;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.name.Names;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.internal.AssumptionViolatedException;
import org.junit.rules.MethodRule;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;
import org.nuxeo.common.function.ThrowableConsumer;
import org.nuxeo.common.function.ThrowableRunnable;
import org.nuxeo.runtime.RuntimeServiceException;
import org.nuxeo.runtime.test.TargetResourceLocator;
import org.nuxeo.runtime.test.runner.AnnotationScanner;
import org.nuxeo.runtime.test.runner.Defaults;
import org.nuxeo.runtime.test.runner.FeaturesLoader;
import org.nuxeo.runtime.test.runner.MethodSorter;
import org.nuxeo.runtime.test.runner.RunnerFeature;

public class FeaturesRunner
extends BlockJUnit4ClassRunner {
    private static final Logger log = LogManager.getLogger(FeaturesRunner.class);
    protected static final AnnotationScanner scanner = new AnnotationScanner();
    protected static final String CUSTOM_ENVIRONMENT_SYSTEM_PROPERTY = "custom.environment";
    protected static final String DEFAULT_BUILD_DIRECTORY = "target";
    protected Injector injector;
    protected final FeaturesLoader loader = new FeaturesLoader(this);
    protected final TargetResourceLocator locator;
    protected Object underTest;

    public static AnnotationScanner getScanner() {
        return scanner;
    }

    public static String getBuildDirectory() {
        String customEnvironment = System.getProperty(CUSTOM_ENVIRONMENT_SYSTEM_PROPERTY);
        return customEnvironment == null ? DEFAULT_BUILD_DIRECTORY : String.format("%s-%s", DEFAULT_BUILD_DIRECTORY, customEnvironment);
    }

    public FeaturesRunner(Class<?> classToRun) throws InitializationError {
        super(classToRun);
        this.locator = new TargetResourceLocator(classToRun);
        try {
            this.loader.loadFeatures(this.getTargetTestClass());
        }
        catch (Throwable t) {
            throw new InitializationError(Collections.singletonList(t));
        }
    }

    public Class<?> getTargetTestClass() {
        return super.getTestClass().getJavaClass();
    }

    public Object getTargetTestInstance() {
        return this.underTest;
    }

    @Deprecated(since="11.1")
    public Path getTargetTestBasepath() {
        return this.locator.getBasepath();
    }

    public URL getTargetTestResource(String name) throws IOException {
        return this.locator.getTargetTestResource(name);
    }

    public Iterable<RunnerFeature> getFeatures() {
        return this.loader.features();
    }

    public <T extends Annotation> T getConfig(Class<T> type) {
        ArrayList configs = new ArrayList();
        T annotation = scanner.getAnnotation(this.getTargetTestClass(), type);
        if (annotation != null) {
            configs.add(annotation);
        }
        this.apply("getAnnotation", Direction.BACKWARD, (ThrowableConsumer<FeaturesLoader.Holder, Exception>)((ThrowableConsumer)holder -> {
            Object hAnnotation = scanner.getAnnotation(holder.type, type);
            if (hAnnotation != null) {
                configs.add(hAnnotation);
            }
        }));
        return Defaults.of(type, configs);
    }

    public <T extends Annotation> T getConfig(FrameworkMethod method, Class<T> type) {
        Annotation config = method.getAnnotation(type);
        if (config != null) {
            return (T)config;
        }
        return this.getConfig(type);
    }

    protected List<FrameworkMethod> computeTestMethods() {
        ArrayList<FrameworkMethod> methods = super.computeTestMethods();
        methods = new ArrayList<FrameworkMethod>(methods);
        MethodSorter.sortMethodsUsingSourceOrder(methods);
        return methods;
    }

    protected void initialize() throws Exception {
        log.trace("Invoke initialize on features");
        for (RunnerFeature each : this.getFeatures()) {
            each.initialize(this);
        }
    }

    protected void beforeRun() {
        this.apply("beforeRun", Direction.FORWARD, (ThrowableConsumer<FeaturesLoader.Holder, Exception>)((ThrowableConsumer)holder -> holder.feature.beforeRun(this)));
    }

    protected void beforeMethodRun(FrameworkMethod method, Object test) {
        this.apply("beforeMethodRun", Direction.FORWARD, (ThrowableConsumer<FeaturesLoader.Holder, Exception>)((ThrowableConsumer)holder -> holder.feature.beforeMethodRun(this, method, test)));
    }

    protected void afterMethodRun(FrameworkMethod method, Object test) {
        this.apply("afterMethodRun", Direction.FORWARD, (ThrowableConsumer<FeaturesLoader.Holder, Exception>)((ThrowableConsumer)holder -> holder.feature.afterMethodRun(this, method, test)));
    }

    protected void afterRun() {
        this.apply("afterRun", Direction.BACKWARD, (ThrowableConsumer<FeaturesLoader.Holder, Exception>)((ThrowableConsumer)holder -> holder.feature.afterRun(this)));
    }

    protected void start() {
        this.apply("start", Direction.FORWARD, (ThrowableConsumer<FeaturesLoader.Holder, Exception>)((ThrowableConsumer)holder -> holder.feature.start(this)));
    }

    protected void stop() {
        this.apply("stop", Direction.BACKWARD, (ThrowableConsumer<FeaturesLoader.Holder, Exception>)((ThrowableConsumer)holder -> holder.feature.stop(this)));
    }

    protected void beforeSetup(FrameworkMethod method, Object test) {
        this.apply("beforeSetup", Direction.FORWARD, (ThrowableConsumer<FeaturesLoader.Holder, Exception>)((ThrowableConsumer)holder -> holder.feature.beforeSetup(this, method, test)));
        this.injector.injectMembers(this.underTest);
    }

    protected void afterTeardown(FrameworkMethod method, Object test) {
        this.apply("afterTeardown", Direction.BACKWARD, (ThrowableConsumer<FeaturesLoader.Holder, Exception>)((ThrowableConsumer)holder -> holder.feature.afterTeardown(this, method, test)));
    }

    protected void apply(String id, Direction direction, ThrowableConsumer<FeaturesLoader.Holder, Exception> consumer) {
        this.apply(id, direction == Direction.FORWARD ? this.loader.holders() : this.loader.reversedHolders(), consumer);
    }

    protected void apply(String id, Collection<FeaturesLoader.Holder> holders, ThrowableConsumer<FeaturesLoader.Holder, Exception> consumer) {
        log.trace("Invoke: {} on features: {}", new org.apache.logging.log4j.util.Supplier[]{() -> id, () -> this.formatFeatures(holders)});
        Supplier<String> msg = () -> String.format("Error while invoking %s on features: %s", id, this.formatFeatures(holders));
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        for (FeaturesLoader.Holder holder : holders) {
            try {
                consumer.accept((Object)holder);
            }
            catch (AssumptionViolatedException cause) {
                log.debug("Test ignored by the feature: {}", holder.type);
                throw cause;
            }
            catch (InterruptedException cause) {
                Thread.currentThread().interrupt();
                throw new RuntimeServiceException(msg.get(), (Throwable)cause);
            }
            catch (Throwable cause) {
                log.debug("Error while invoking: {} on feature: {}", (Object)id, holder.type);
                this.throwSeriousError(cause);
                errors.add(cause);
            }
        }
        if (!errors.isEmpty()) {
            AssertionError exception = new AssertionError((Object)msg.get());
            errors.forEach(arg_0 -> exception.addSuppressed(arg_0));
            throw exception;
        }
    }

    protected String formatFeatures(Collection<FeaturesLoader.Holder> holders) {
        return holders.stream().map(h -> h.type.getName()).collect(Collectors.joining(", ", "[", "]"));
    }

    public void evaluateRunnable(ThrowableRunnable<Throwable> runnable, ThrowableRunnable<Throwable> finisher) throws Throwable {
        Throwable error = null;
        try {
            runnable.run();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeServiceException((Throwable)e);
        }
        catch (Throwable t) {
            this.throwSeriousError(t);
            error = t;
        }
        try {
            finisher.run();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeServiceException((Throwable)e);
        }
        catch (Throwable t) {
            this.throwSeriousError(t);
            if (error == null) {
                error = t;
            }
            error.addSuppressed(t);
        }
        if (error != null) {
            throw error;
        }
    }

    protected void throwSeriousError(Throwable cause) {
        if (cause instanceof Error && !(cause instanceof AssertionError)) {
            throw (Error)cause;
        }
    }

    public Injector getInjector() {
        return this.injector;
    }

    protected Injector onInjector(RunNotifier aNotifier) {
        return Guice.createInjector((Stage)Stage.DEVELOPMENT, (Module[])new Module[]{aBinder -> {
            aBinder.bind(FeaturesRunner.class).toInstance((Object)this);
            aBinder.bind(RunNotifier.class).toInstance((Object)aNotifier);
            aBinder.bind(TargetResourceLocator.class).toInstance((Object)this.locator);
        }});
    }

    protected Statement withAfterClasses(Statement statement) {
        Statement actual = statement;
        actual = super.withAfterClasses(actual);
        actual = new AfterClassStatement(actual);
        return actual;
    }

    protected Statement classBlock(RunNotifier aNotifier) {
        this.injector = this.onInjector(aNotifier);
        return super.classBlock(aNotifier);
    }

    protected List<TestRule> classRules() {
        RulesFactory<ClassRule, TestRule> factory = new RulesFactory<ClassRule, TestRule>(ClassRule.class, TestRule.class);
        factory.withRule((base, description) -> new BeforeClassStatement(base)).withRules(super.classRules());
        this.apply("classRules", Direction.FORWARD, (ThrowableConsumer<FeaturesLoader.Holder, Exception>)((ThrowableConsumer)holder -> factory.withRules(holder.testClass, null)));
        return factory.build();
    }

    protected Statement withBefores(FrameworkMethod method, Object target, Statement statement) {
        Statement actual = statement;
        actual = new BeforeMethodRunStatement(method, target, actual);
        actual = super.withBefores(method, target, actual);
        actual = new BeforeSetupStatement(method, target, actual);
        return actual;
    }

    protected Statement withAfters(FrameworkMethod method, Object target, Statement statement) {
        Statement actual = statement;
        actual = new AfterMethodRunStatement(method, target, actual);
        actual = super.withAfters(method, target, actual);
        actual = new AfterTeardownStatement(method, target, actual);
        return actual;
    }

    protected List<TestRule> getTestRules(Object target) {
        RulesFactory<Rule, TestRule> factory = new RulesFactory<Rule, TestRule>(Rule.class, TestRule.class);
        this.apply("getTestRules", Direction.FORWARD, (ThrowableConsumer<FeaturesLoader.Holder, Exception>)((ThrowableConsumer)holder -> factory.withRules(holder.testClass, holder.feature)));
        factory.withRules(this.getTestClass(), target);
        return factory.build();
    }

    protected List<MethodRule> rules(Object target) {
        RulesFactory<Rule, MethodRule> factory = new RulesFactory<Rule, MethodRule>(Rule.class, MethodRule.class);
        this.apply("rules", Direction.FORWARD, (ThrowableConsumer<FeaturesLoader.Holder, Exception>)((ThrowableConsumer)holder -> factory.withRules(holder.testClass, holder.feature)));
        factory.withRules(this.getTestClass(), target);
        return factory.build();
    }

    public Object createTest() throws Exception {
        this.underTest = super.createTest();
        this.apply("createTest", Direction.FORWARD, (ThrowableConsumer<FeaturesLoader.Holder, Exception>)((ThrowableConsumer)holder -> holder.feature.testCreated(this.underTest)));
        return this.underTest;
    }

    protected void validateZeroArgConstructor(List<Throwable> errors) {
    }

    public String toString() {
        return "FeaturesRunner [fTest=" + this.getTargetTestClass() + "]";
    }

    public <T extends RunnerFeature> T getFeature(Class<T> aType) {
        return this.loader.getFeature(aType);
    }

    protected static enum Direction {
        FORWARD,
        BACKWARD;

    }

    protected class RulesFactory<A extends Annotation, R> {
        protected final Class<A> annotationType;
        protected final Class<R> ruleType;
        protected ArrayList<R> rules = new ArrayList();

        protected Statement build(final Statement base, final String name) {
            return new Statement(){

                public void evaluate() throws Throwable {
                    FeaturesRunner.this.injector = FeaturesRunner.this.injector.createChildInjector(new Module[]{binder -> {
                        for (Object each : RulesFactory.this.rules) {
                            binder.bind(each.getClass()).annotatedWith((Annotation)Names.named((String)name)).toInstance(each);
                            binder.requestInjection(each);
                        }
                    }});
                    try {
                        base.evaluate();
                    }
                    finally {
                        FeaturesRunner.this.injector = FeaturesRunner.this.injector.getParent();
                    }
                }
            };
        }

        protected RulesFactory(Class<A> anAnnotationType, Class<R> aRuleType) {
            this.annotationType = anAnnotationType;
            this.ruleType = aRuleType;
        }

        public RulesFactory<A, R> withRules(List<R> someRules) {
            this.rules.addAll(someRules);
            return this;
        }

        public RulesFactory<A, R> withRule(R aRule) {
            FeaturesRunner.this.injector.injectMembers(aRule);
            this.rules.add(aRule);
            return this;
        }

        public RulesFactory<A, R> withRules(TestClass aType, Object aTest) {
            for (Object each : aType.getAnnotatedFieldValues(aTest, this.annotationType, this.ruleType)) {
                this.withRule(each);
            }
            for (Object each : aType.getAnnotatedMethods(this.annotationType)) {
                if (!this.ruleType.isAssignableFrom(each.getMethod().getReturnType())) continue;
                this.withRule(this.onMethod(this.ruleType, (FrameworkMethod)each, aTest, new Object[0]));
            }
            return this;
        }

        public List<R> build() {
            return Collections.singletonList(this.ruleType.cast(new BindRule()));
        }

        protected R onMethod(Class<R> aRuleType, FrameworkMethod aMethod, Object aTarget, Object ... someParms) {
            try {
                return aRuleType.cast(aMethod.invokeExplosively(aTarget, someParms));
            }
            catch (Throwable cause) {
                throw new RuntimeServiceException("Errors in rules factory " + aMethod, cause);
            }
        }

        protected class BindRule
        implements TestRule,
        MethodRule {
            protected BindRule() {
            }

            public Statement apply(Statement base, FrameworkMethod method, Object target) {
                Statement statement = RulesFactory.this.build(base, "method");
                for (Object each : RulesFactory.this.rules) {
                    statement = ((MethodRule)each).apply(statement, method, target);
                }
                return statement;
            }

            public Statement apply(Statement base, Description description) {
                if (RulesFactory.this.rules.isEmpty()) {
                    return base;
                }
                Statement statement = RulesFactory.this.build(base, "test");
                for (Object each : RulesFactory.this.rules) {
                    statement = ((TestRule)each).apply(statement, description);
                }
                return statement;
            }
        }
    }

    protected class AfterTeardownStatement
    extends MethodStatement {
        protected AfterTeardownStatement(FrameworkMethod method, Object target, Statement statement) {
            super(method, target, statement);
        }

        public void evaluate() throws Throwable {
            FeaturesRunner.this.evaluateRunnable((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> ((Statement)this.statement).evaluate()), (ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> FeaturesRunner.this.afterTeardown(this.method, this.target)));
        }
    }

    protected class AfterMethodRunStatement
    extends MethodStatement {
        protected AfterMethodRunStatement(FrameworkMethod method, Object target, Statement statement) {
            super(method, target, statement);
        }

        public void evaluate() throws Throwable {
            FeaturesRunner.this.evaluateRunnable((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> ((Statement)this.statement).evaluate()), (ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> FeaturesRunner.this.afterMethodRun(this.method, this.target)));
        }
    }

    protected class BeforeSetupStatement
    extends MethodStatement {
        protected BeforeSetupStatement(FrameworkMethod method, Object target, Statement statement) {
            super(method, target, statement);
        }

        public void evaluate() throws Throwable {
            FeaturesRunner.this.beforeSetup(this.method, this.target);
            this.statement.evaluate();
        }
    }

    protected class BeforeMethodRunStatement
    extends MethodStatement {
        protected BeforeMethodRunStatement(FrameworkMethod method, Object target, Statement statement) {
            super(method, target, statement);
        }

        public void evaluate() throws Throwable {
            FeaturesRunner.this.beforeMethodRun(this.method, this.target);
            this.statement.evaluate();
        }
    }

    protected static abstract class MethodStatement
    extends Statement {
        protected final FrameworkMethod method;
        protected final Object target;
        protected final Statement statement;

        public MethodStatement(FrameworkMethod method, Object target, Statement statement) {
            this.method = method;
            this.target = target;
            this.statement = statement;
        }
    }

    protected class AfterClassStatement
    extends Statement {
        protected final Statement previous;

        protected AfterClassStatement(Statement aStatement) {
            this.previous = aStatement;
        }

        public void evaluate() throws Throwable {
            this.previous.evaluate();
            FeaturesRunner.this.evaluateRunnable((ThrowableRunnable<Throwable>)((ThrowableRunnable)FeaturesRunner.this::afterRun), (ThrowableRunnable<Throwable>)((ThrowableRunnable)FeaturesRunner.this::stop));
        }
    }

    protected class BeforeClassStatement
    extends Statement {
        protected final Statement next;

        protected BeforeClassStatement(Statement aStatement) {
            this.next = aStatement;
        }

        public void evaluate() throws Throwable {
            FeaturesRunner.this.initialize();
            FeaturesRunner.this.start();
            FeaturesRunner.this.beforeRun();
            FeaturesRunner.this.injector = FeaturesRunner.this.injector.createChildInjector(new Module[]{FeaturesRunner.this.loader.onModule()});
            try {
                this.next.evaluate();
            }
            finally {
                FeaturesRunner.this.injector = FeaturesRunner.this.injector.getParent();
            }
        }
    }
}

