/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test;

import java.util.List;
import junit.framework.AssertionFailedError;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;

public class Failures {
    private static final Log log = LogFactory.getLog(Failures.class);
    private List<Failure> failures;

    public Failures(List<Failure> failures) {
        this.failures = failures;
    }

    public Failures(Result result) {
        this.failures = result.getFailures();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int i = 1;
        AssertionFailedError errors = new AssertionFailedError();
        for (Failure failure : this.failures) {
            sb.append("* Failure ").append(i).append(": ").append(failure.getTestHeader()).append("\n").append(failure.getTrace()).append("\n");
            errors.addSuppressed(failure.getException());
            ++i;
        }
        if (errors.getSuppressed().length > 0) {
            log.debug((Object)errors.getMessage(), (Throwable)errors);
        }
        return sb.toString();
    }

    public void fail(String originalMessage, String customMessage) {
        if (this.failures.isEmpty()) {
            Assert.fail((String)customMessage);
        }
        StringBuilder sb = new StringBuilder();
        int i = 1;
        AssertionFailedError errors = new AssertionFailedError(customMessage);
        sb.append(customMessage);
        for (Failure failure : this.failures) {
            sb.append("\n* Failure ").append(i).append(": ");
            String trace = failure.getTrace();
            if (originalMessage != null && originalMessage.equals(failure.getMessage())) {
                trace = trace.replaceAll(originalMessage, customMessage);
            }
            sb.append(failure.getTestHeader()).append("\n").append(trace);
            errors.addSuppressed(failure.getException());
            ++i;
        }
        log.debug((Object)errors.getMessage(), (Throwable)errors);
        Assert.fail((String)sb.toString());
    }
}

