/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test.logging;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.filter.ThresholdFilter;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.RunWith;
import org.junit.runners.model.Statement;
import org.nuxeo.runtime.test.runner.ConsoleLogLevelThreshold;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LogFeature;
import org.nuxeo.runtime.test.runner.LoggerLevel;
import org.nuxeo.runtime.test.runner.LoggerLevels;
import org.nuxeo.runtime.test.runner.RuntimeFeature;

@RunWith(value=FeaturesRunner.class)
@Features(value={RuntimeFeature.class, LogFeature.class})
@LoggerLevels(value={@LoggerLevel(name="org.nuxeo.FakeClass2", level="DEBUG"), @LoggerLevel(name="org.nuxeo.FakeClass3", level="FATAL")})
public class TestLogFeature {
    protected static final Logger log = LogManager.getLogger(TestLogFeature.class);
    protected static final String FAKE_LOGGER_NAME_1 = "org.nuxeo.FakeClass1";
    protected static final String FAKE_LOGGER_NAME_2 = "org.nuxeo.FakeClass2";
    protected static final String FAKE_LOGGER_NAME_3 = "org.nuxeo.FakeClass3";
    @ClassRule
    public static final LogFeatureClassCheckerRule LOG_FEATURE_CLASS_CHECKER_RULE = new LogFeatureClassCheckerRule();
    @Rule
    public final LogFeatureMethodCheckerRule logFeatureMethodCheckerRule = new LogFeatureMethodCheckerRule();

    @Test
    @LoggerLevel(name="org.nuxeo.FakeClass1", level="TRACE")
    public void shouldAddNewLogger() {
        Assert.assertTrue((boolean)LogManager.getLogger((String)FAKE_LOGGER_NAME_1).isTraceEnabled());
    }

    @Test
    @LoggerLevel(klass=TestLogFeature.class, level="DEBUG")
    public void shouldUpdateLogger() {
        Assert.assertTrue((boolean)LogManager.getLogger(TestLogFeature.class).isDebugEnabled());
    }

    @Test
    @LoggerLevels(value={@LoggerLevel(name="org.nuxeo.FakeClass2", level="TRACE"), @LoggerLevel(name="org.nuxeo.FakeClass3", level="INFO")})
    public void shouldOverrideTestLoggerDefinition() {
        Assert.assertTrue((boolean)LogManager.getLogger((String)FAKE_LOGGER_NAME_2).isTraceEnabled());
        Assert.assertTrue((boolean)LogManager.getLogger((String)FAKE_LOGGER_NAME_3).isInfoEnabled());
    }

    @Test
    public void shouldInheritLogger() {
        Assert.assertTrue((boolean)LogManager.getLogger((String)FAKE_LOGGER_NAME_2).isDebugEnabled());
        Assert.assertTrue((boolean)LogManager.getLogger((String)FAKE_LOGGER_NAME_3).isFatalEnabled());
    }

    @Test
    @ConsoleLogLevelThreshold(value="FATAL")
    public void shouldSetConsoleLogThreshold() {
        LoggerContext context = LoggerContext.getContext((boolean)false);
        org.apache.logging.log4j.core.Logger rootLogger = context.getRootLogger();
        Appender appender = (Appender)rootLogger.getAppenders().get("CONSOLE_LOG_FEATURE");
        Assert.assertNotNull((Object)appender);
        ConsoleAppender console = (ConsoleAppender)appender;
        Filter filter = console.getFilter();
        Assert.assertNotNull((Object)filter);
        Assert.assertTrue((boolean)(filter instanceof ThresholdFilter));
        ThresholdFilter threshold = (ThresholdFilter)filter;
        Assert.assertEquals((Object)Level.FATAL, (Object)threshold.getLevel());
    }

    public class LogFeatureMethodCheckerRule
    implements TestRule {
        public Statement apply(final Statement base, final Description description) {
            return new Statement(){

                public void evaluate() throws Throwable {
                    this.before(description);
                    try {
                        base.evaluate();
                    }
                    finally {
                        this.after(description);
                    }
                }

                protected void before(Description description2) {
                    LogFeatureMethodCheckerRule.this.getLoggersAnnotations(description2).forEach(a -> LogFeatureMethodCheckerRule.this.check((LoggerLevel)a, true));
                }

                protected void after(Description description2) {
                    LogFeatureMethodCheckerRule.this.getLoggersAnnotations(description2).forEach(a -> LogFeatureMethodCheckerRule.this.check((LoggerLevel)a, false));
                }
            };
        }

        protected Collection<LoggerLevel> getLoggersAnnotations(Description description) {
            LoggerLevels loggers;
            ArrayList<LoggerLevel> annotations = new ArrayList<LoggerLevel>();
            LoggerLevel logger = (LoggerLevel)description.getAnnotation(LoggerLevel.class);
            if (logger != null) {
                annotations.add(logger);
            }
            if ((loggers = (LoggerLevels)description.getAnnotation(LoggerLevels.class)) != null) {
                annotations.addAll(List.of(loggers.value()));
            }
            return annotations;
        }

        protected void check(LoggerLevel logger, boolean before) {
            LoggerContext context = LoggerContext.getContext((boolean)false);
            if (logger.klass().equals(TestLogFeature.class)) {
                Assert.assertEquals((Object)Level.INFO, (Object)log.getLevel());
            } else {
                switch (logger.name()) {
                    case "org.nuxeo.FakeClass1": {
                        if (before) {
                            Assert.assertFalse((boolean)context.hasLogger(TestLogFeature.FAKE_LOGGER_NAME_1));
                            break;
                        }
                        Assert.assertEquals((Object)Level.OFF, (Object)LogManager.getLogger((String)TestLogFeature.FAKE_LOGGER_NAME_1).getLevel());
                        break;
                    }
                    case "org.nuxeo.FakeClass2": {
                        Assert.assertEquals((Object)Level.DEBUG, (Object)LogManager.getLogger((String)TestLogFeature.FAKE_LOGGER_NAME_2).getLevel());
                        break;
                    }
                    case "org.nuxeo.FakeClass3": {
                        Assert.assertEquals((Object)Level.FATAL, (Object)LogManager.getLogger((String)TestLogFeature.FAKE_LOGGER_NAME_3).getLevel());
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
        }
    }

    public static class LogFeatureClassCheckerRule
    implements TestRule {
        public Statement apply(final Statement base, Description description) {
            return new Statement(){

                public void evaluate() throws Throwable {
                    this.before();
                    try {
                        base.evaluate();
                    }
                    finally {
                        this.after();
                    }
                }

                protected void before() {
                    LoggerContext context = LoggerContext.getContext((boolean)false);
                    Assert.assertTrue((boolean)log.isInfoEnabled());
                    Assert.assertFalse((boolean)context.hasLogger(TestLogFeature.FAKE_LOGGER_NAME_1));
                    Assert.assertFalse((boolean)context.hasLogger(TestLogFeature.FAKE_LOGGER_NAME_2));
                    Assert.assertFalse((boolean)context.hasLogger(TestLogFeature.FAKE_LOGGER_NAME_3));
                }

                protected void after() {
                    Assert.assertTrue((boolean)log.isInfoEnabled());
                    Assert.assertEquals((Object)Level.OFF, (Object)LogManager.getLogger((String)TestLogFeature.FAKE_LOGGER_NAME_1).getLevel());
                    Assert.assertEquals((Object)Level.OFF, (Object)LogManager.getLogger((String)TestLogFeature.FAKE_LOGGER_NAME_2).getLevel());
                    Assert.assertEquals((Object)Level.OFF, (Object)LogManager.getLogger((String)TestLogFeature.FAKE_LOGGER_NAME_3).getLevel());
                }
            };
        }
    }
}

