/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.mockito;

import org.apache.commons.lang3.reflect.FieldUtils;
import org.mockito.MockitoAnnotations;
import org.mockito.internal.configuration.GlobalConfiguration;
import org.nuxeo.runtime.api.DefaultServiceProvider;
import org.nuxeo.runtime.api.ServiceProvider;
import org.nuxeo.runtime.mockito.MockProvider;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.RunnerFeature;

public class MockitoFeature
implements RunnerFeature {
    protected final MockProvider provider = new MockProvider();

    @Override
    public void start(FeaturesRunner runner) {
        this.provider.installSelf();
    }

    @Override
    public void testCreated(Object test) {
        DefaultServiceProvider.setProvider((ServiceProvider)this.provider);
        MockitoAnnotations.initMocks((Object)test);
    }

    @Override
    public void afterRun(FeaturesRunner runner) throws Exception {
        this.cleanupThread();
    }

    @Override
    public void stop(FeaturesRunner runner) {
        this.provider.uninstallSelf();
    }

    protected void cleanupThread() throws ReflectiveOperationException {
        ThreadLocal holder = (ThreadLocal)FieldUtils.readStaticField(GlobalConfiguration.class, (String)"globalConfiguration", (boolean)true);
        holder.remove();
    }
}

