/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test.runner;

import java.io.IOException;
import java.net.ServerSocket;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.RunnerFeature;
import org.nuxeo.runtime.test.runner.RuntimeFeature;
import org.nuxeo.runtime.test.runner.ServletContainer;

@Deploy(value={"org.nuxeo.runtime.server"})
@Features(value={RuntimeFeature.class})
public class ServletContainerFeature
implements RunnerFeature {
    private static final Logger log = LogManager.getLogger(ServletContainerFeature.class);
    protected static final int RETRIES = 1000;
    protected int port;

    @Override
    public void initialize(FeaturesRunner runner) throws Exception {
        int port;
        ServletContainer conf = runner.getConfig(ServletContainer.class);
        int n = port = conf == null ? 0 : conf.port();
        if (port <= 0) {
            port = this.findFreePort();
        }
        this.port = port;
        System.setProperty("nuxeo.servlet-container.port", String.valueOf(port));
        System.setProperty("nuxeo.server.http.port", String.valueOf(port));
    }

    protected int findFreePort() {
        int i = 0;
        while (i < 1000) {
            int n;
            ServerSocket socket = new ServerSocket(0);
            try {
                socket.setReuseAddress(true);
                n = socket.getLocalPort();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        socket.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.trace("Failed to allocate port", (Throwable)e);
                    ++i;
                }
            }
            socket.close();
            return n;
        }
        throw new RuntimeException("Unable to find free port after 1000 retries");
    }

    public int getPort() {
        return this.port;
    }
}

