/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test.runner;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.runtime.test.WorkingDirectoryConfigurator;
import org.nuxeo.runtime.test.runner.Defaults;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.Jetty;
import org.nuxeo.runtime.test.runner.RuntimeFeature;
import org.nuxeo.runtime.test.runner.RuntimeHarness;
import org.nuxeo.runtime.test.runner.SimpleFeature;

@Deploy(value={"org.nuxeo.runtime.jetty"})
@Features(value={RuntimeFeature.class})
public class JettyFeature
extends SimpleFeature
implements WorkingDirectoryConfigurator {
    public void initialize(FeaturesRunner runner) throws Exception {
        String v;
        int p;
        Jetty jetty = FeaturesRunner.getScanner().getFirstAnnotation(runner.getTargetTestClass(), Jetty.class);
        if (jetty == null) {
            jetty = Defaults.of(Jetty.class);
        }
        if ((p = jetty.port()) > 0) {
            System.setProperty("jetty.port", Integer.toString(p));
        }
        if ((v = jetty.host()).length() > 0) {
            System.setProperty("jetty.host", jetty.host());
        }
        if ((v = jetty.config()).length() > 0) {
            System.setProperty("org.nuxeo.jetty.config", jetty.config());
        }
        runner.getFeature(RuntimeFeature.class).getHarness().addWorkingDirectoryConfigurator(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(RuntimeHarness harness, File workingDir) throws IOException {
        File dest = new File(workingDir, "config");
        dest.mkdirs();
        InputStream in = JettyFeature.getResource("jetty/default-web.xml").openStream();
        dest = new File(workingDir + "/config", "default-web.xml");
        try {
            FileUtils.copyToFile((InputStream)in, (File)dest);
        }
        finally {
            in.close();
        }
        in = JettyFeature.getResource("jetty/jetty.xml").openStream();
        dest = new File(workingDir + "/config", "jetty.xml");
        try {
            FileUtils.copyToFile((InputStream)in, (File)dest);
        }
        finally {
            in.close();
        }
    }

    private static URL getResource(String resource) {
        return Jetty.class.getClassLoader().getResource(resource);
    }
}

