/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test.runner.web;

import org.nuxeo.runtime.test.runner.web.DriverFactory;
import org.openqa.selenium.Speed;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum BrowserFamily {
    FIREFOX,
    IE,
    CHROME,
    HTML_UNIT,
    HTML_UNIT_JS;


    public DriverFactory getDriverFactory() {
        switch (this) {
            case FIREFOX: {
                return new FirefoxDriverFactory();
            }
            case IE: {
                return new IEDriverFactory();
            }
            case CHROME: {
                return new ChromeDriverFactory();
            }
            case HTML_UNIT_JS: {
                return new HtmlUnitJsDriverFactory();
            }
        }
        return new HtmlUnitDriverFactory();
    }

    class HtmlUnitJsDriverFactory
    implements DriverFactory {
        HtmlUnitJsDriverFactory() {
        }

        public WebDriver createDriver() {
            HtmlUnitDriver driver = new HtmlUnitDriver();
            driver.setJavascriptEnabled(true);
            return driver;
        }

        public void disposeDriver(WebDriver driver) {
        }

        public BrowserFamily getBrowserFamily() {
            return BrowserFamily.this;
        }
    }

    class HtmlUnitDriverFactory
    implements DriverFactory {
        HtmlUnitDriverFactory() {
        }

        public WebDriver createDriver() {
            return new HtmlUnitDriver();
        }

        public void disposeDriver(WebDriver driver) {
        }

        public BrowserFamily getBrowserFamily() {
            return BrowserFamily.this;
        }
    }

    class IEDriverFactory
    implements DriverFactory {
        IEDriverFactory() {
        }

        public WebDriver createDriver() {
            InternetExplorerDriver driver = new InternetExplorerDriver();
            driver.setVisible(true);
            driver.manage().setSpeed(Speed.FAST);
            return driver;
        }

        public void disposeDriver(WebDriver driver) {
        }

        public BrowserFamily getBrowserFamily() {
            return BrowserFamily.this;
        }
    }

    class ChromeDriverFactory
    implements DriverFactory {
        ChromeDriverFactory() {
        }

        public WebDriver createDriver() {
            ChromeDriver ff = new ChromeDriver();
            ff.manage().setSpeed(Speed.FAST);
            return ff;
        }

        public void disposeDriver(WebDriver driver) {
        }

        public BrowserFamily getBrowserFamily() {
            return BrowserFamily.this;
        }
    }

    class FirefoxDriverFactory
    implements DriverFactory {
        FirefoxDriverFactory() {
        }

        public WebDriver createDriver() {
            FirefoxDriver ff = new FirefoxDriver();
            ff.manage().setSpeed(Speed.FAST);
            return ff;
        }

        public void disposeDriver(WebDriver driver) {
        }

        public BrowserFamily getBrowserFamily() {
            return BrowserFamily.this;
        }
    }
}

