/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test.protocols.inline;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuxeo.common.utils.Base64;
import org.nuxeo.common.utils.URLStreamHandlerFactoryInstaller;
import org.nuxeo.runtime.test.protocols.inline.InlineURLStreamHandlerFactory;

public class InlineURLFactory {
    protected static final Pattern pattern = Pattern.compile("inline:(.*);base64,(.*)");

    public static void install() {
        try {
            URLStreamHandlerFactoryInstaller.installURLStreamHandlerFactory((URLStreamHandlerFactory)new InlineURLStreamHandlerFactory());
        }
        catch (Exception e) {
            throw new Error("Cannot install inline URLs", e);
        }
    }

    public static <T> byte[] marshall(T content) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(content);
        return bos.toByteArray();
    }

    public static <T> T unmarshall(Class<T> clazz, byte[] data) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(data);
        ObjectInputStream ois = new ObjectInputStream(is);
        try {
            return clazz.cast(ois.readObject());
        }
        catch (ClassNotFoundException e) {
            throw new Error("Cannot decode, object is not of class " + clazz.getSimpleName(), e);
        }
    }

    public static <T> URL newURL(T content) throws IOException {
        byte[] data = InlineURLFactory.marshall(content);
        return InlineURLFactory.newURL("application/java", data);
    }

    public static URL newURL(String mimetype, byte[] data) throws IOException {
        return new URL("inline:".concat(mimetype).concat(";base64,".concat(Base64.encodeBytes((byte[])data))));
    }

    public static <T> T newObject(Class<T> clazz, URL url) throws IOException {
        byte[] data = InlineURLFactory.getBytes(url);
        return InlineURLFactory.unmarshall(clazz, data);
    }

    public static byte[] getBytes(URL url) throws IOException {
        Matcher matcher = pattern.matcher(url.toExternalForm());
        if (!matcher.matches()) {
            throw new IllegalArgumentException("'" + url + "' should be 'inline:mimetype;base64,content'");
        }
        String mimetype = matcher.group(1);
        String data = matcher.group(2);
        return Base64.decode((String)data);
    }
}

