/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.configuration;

import org.mockito.configuration.AnnotationEngine;
import org.mockito.configuration.NuxeoDefaultAnnotationEngine;
import org.mockito.internal.configuration.InjectingAnnotationEngine;
import org.mockito.internal.configuration.SpyAnnotationEngine;

public class NuxeoInjectingAnnotationEngine
extends InjectingAnnotationEngine {
    private AnnotationEngine delegate = new NuxeoDefaultAnnotationEngine();
    private AnnotationEngine spyAnnotationEngine = new SpyAnnotationEngine();

    public void process(Class<?> clazz, Object testInstance) {
        this.processIndependentAnnotations(testInstance.getClass(), testInstance);
        this.processInjectMocks(testInstance.getClass(), testInstance);
    }

    private void processInjectMocks(Class<?> clazz, Object testInstance) {
        for (Class<?> classContext = clazz; classContext != Object.class; classContext = classContext.getSuperclass()) {
            this.injectMocks(testInstance);
        }
    }

    private void processIndependentAnnotations(Class<?> clazz, Object testInstance) {
        for (Class<?> classContext = clazz; classContext != Object.class; classContext = classContext.getSuperclass()) {
            this.delegate.process(classContext, testInstance);
            this.spyAnnotationEngine.process(classContext, testInstance);
        }
    }
}

