/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test.runner;

import com.google.common.base.Supplier;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.nuxeo.osgi.BundleImpl;
import org.nuxeo.runtime.model.RuntimeContext;
import org.nuxeo.runtime.osgi.OSGiRuntimeService;
import org.nuxeo.runtime.test.runner.AnnotationScanner;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;
import org.nuxeo.runtime.test.runner.RunnerFeature;
import org.nuxeo.runtime.test.runner.RuntimeFeature;
import org.nuxeo.runtime.test.runner.RuntimeHarness;
import org.osgi.framework.Bundle;

public class RuntimeDeployment {
    Set<String> bundles = new HashSet<String>();
    Map<String, Collection<String>> mainContribs = new HashMap<String, Collection<String>>();
    SetMultimap<String, String> mainIndex = Multimaps.newSetMultimap(this.mainContribs, (Supplier)new Supplier<Set<String>>(){

        public Set<String> get() {
            return new HashSet<String>();
        }
    });
    Map<String, Collection<String>> localContribs = new HashMap<String, Collection<String>>();
    SetMultimap<String, String> localIndex = Multimaps.newSetMultimap(this.localContribs, (Supplier)new Supplier<Set<String>>(){

        public Set<String> get() {
            return new HashSet<String>();
        }
    });
    protected LinkedList<RuntimeContext> contexts = new LinkedList();

    protected void index(Class<?> clazz) {
        AnnotationScanner scanner = FeaturesRunner.scanner;
        scanner.scan(clazz);
        List<? extends Annotation> annos = scanner.getAnnotations(clazz);
        if (annos == null) {
            return;
        }
        for (Annotation annotation : annos) {
            if (annotation.annotationType() == Deploy.class) {
                this.index((Deploy)annotation);
                continue;
            }
            if (annotation.annotationType() != LocalDeploy.class) continue;
            this.index((LocalDeploy)annotation);
        }
    }

    protected void index(RunnerFeature feature) {
        this.index(feature.getClass());
    }

    protected void index(Method method) {
        this.index(method.getAnnotation(Deploy.class));
        this.index(method.getAnnotation(LocalDeploy.class));
    }

    protected void index(Deploy config) {
        if (config == null) {
            return;
        }
        for (String each : config.value()) {
            this.index(each, this.mainIndex);
        }
    }

    protected void index(LocalDeploy config) {
        if (config == null) {
            return;
        }
        for (String each : config.value()) {
            this.index(each, this.localIndex);
        }
    }

    protected void index(Features features) {
        for (Class<? extends RunnerFeature> each : features.value()) {
            this.index(each);
        }
    }

    protected void index(String directive, SetMultimap<String, String> contribs) {
        int sepIndex = directive.indexOf(58);
        if (sepIndex == -1) {
            this.bundles.add(directive);
        } else {
            String bundle = directive.substring(0, sepIndex);
            String resource = directive.substring(sepIndex + 1);
            contribs.put((Object)bundle, (Object)resource);
        }
    }

    protected void deploy(FeaturesRunner runner, RuntimeHarness harness) {
        AssertionError errors = new AssertionError((Object)"deployment errors");
        OSGiRuntimeService runtime = (OSGiRuntimeService)harness.getContext().getRuntime();
        for (String name : this.bundles) {
            BundleImpl bundle = harness.getOSGiAdapter().getBundle(name);
            if (bundle == null) {
                try {
                    harness.deployBundle(name);
                    bundle = harness.getOSGiAdapter().getBundle(name);
                    if (bundle == null) {
                        throw new UnsupportedOperationException("Should not occur");
                    }
                }
                catch (Exception error) {
                    ((Throwable)((Object)errors)).addSuppressed(error);
                    continue;
                }
                this.contexts.add(runtime.getContext((Bundle)bundle));
            }
            try {
                for (String resource : this.mainIndex.removeAll((Object)name)) {
                    try {
                        harness.deployContrib(name, resource);
                    }
                    catch (Exception error) {
                        ((Throwable)((Object)errors)).addSuppressed(error);
                    }
                }
                for (String resource : this.localIndex.removeAll((Object)name)) {
                    URL url = runner.getTargetTestResource(resource);
                    if (url == null) {
                        url = bundle.getEntry(resource);
                    }
                    if (url == null) {
                        url = runner.getTargetTestClass().getClassLoader().getResource(resource);
                    }
                    if (url == null) {
                        throw new AssertionError((Object)("Cannot find " + resource + " in " + name));
                    }
                    this.contexts.add(harness.deployTestContrib(name, url));
                }
            }
            catch (Exception error) {
                ((Throwable)((Object)errors)).addSuppressed(error);
            }
        }
        for (Map.Entry resource : this.mainIndex.entries()) {
            try {
                harness.deployContrib((String)resource.getKey(), (String)resource.getValue());
            }
            catch (Exception error) {
                ((Throwable)((Object)errors)).addSuppressed(error);
            }
        }
        for (Map.Entry resource : this.localIndex.entries()) {
            try {
                this.contexts.add(harness.deployTestContrib((String)resource.getKey(), (String)resource.getValue()));
            }
            catch (Exception error) {
                ((Throwable)((Object)errors)).addSuppressed(error);
            }
        }
        if (((Throwable)((Object)errors)).getSuppressed().length > 0) {
            throw errors;
        }
    }

    void undeploy() {
        AssertionError errors = new AssertionError((Object)"deployment errors");
        Iterator<RuntimeContext> it = this.contexts.descendingIterator();
        while (it.hasNext()) {
            RuntimeContext each = it.next();
            it.remove();
            try {
                each.destroy();
            }
            catch (RuntimeException error) {
                ((Throwable)((Object)errors)).addSuppressed(error);
            }
        }
        if (((Throwable)((Object)errors)).getSuppressed().length > 0) {
            throw errors;
        }
    }

    public static RuntimeDeployment onTest(FeaturesRunner runner) {
        RuntimeDeployment deployment = new RuntimeDeployment();
        deployment.index(runner.getDescription().getTestClass());
        for (RunnerFeature each : runner.getFeatures()) {
            deployment.index(each);
        }
        return deployment;
    }

    public static MethodRule onMethod() {
        return new OnMethod();
    }

    protected Statement onStatement(FeaturesRunner runner, RuntimeHarness harness, Statement base) {
        return new DeploymentStatement(runner, harness, base);
    }

    protected class DeploymentStatement
    extends Statement {
        protected final FeaturesRunner runner;
        protected final RuntimeHarness harness;
        protected final Statement base;

        public DeploymentStatement(FeaturesRunner runner, RuntimeHarness harness, Statement base) {
            this.runner = runner;
            this.harness = harness;
            this.base = base;
        }

        public void evaluate() throws Throwable {
            RuntimeDeployment.this.deploy(this.runner, this.harness);
            try {
                this.base.evaluate();
            }
            finally {
                RuntimeDeployment.this.undeploy();
            }
        }
    }

    protected static class OnMethod
    implements MethodRule {
        @Inject
        protected FeaturesRunner runner;

        protected OnMethod() {
        }

        public Statement apply(Statement base, FrameworkMethod method, Object target) {
            RuntimeDeployment deployment = new RuntimeDeployment();
            deployment.index(method.getMethod());
            return deployment.onStatement(this.runner, this.runner.getFeature(RuntimeFeature.class).harness, base);
        }
    }
}

