/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.mockito;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.mockito.exceptions.Reporter;
import org.mockito.internal.configuration.CaptorAnnotationProcessor;
import org.mockito.internal.configuration.DefaultAnnotationEngine;
import org.mockito.internal.configuration.FieldAnnotationProcessor;
import org.mockito.internal.configuration.MockitoAnnotationsMockAnnotationProcessor;
import org.nuxeo.runtime.mockito.NuxeoServiceMockAnnotationProcessor;

public class NuxeoDefaultAnnotationEngine
extends DefaultAnnotationEngine {
    private final Map<Class<? extends Annotation>, FieldAnnotationProcessor<?>> annotationProcessorMap = new HashMap();

    public NuxeoDefaultAnnotationEngine() {
        this.registerAnnotationProcessor(Mock.class, new NuxeoServiceMockAnnotationProcessor());
        this.registerAnnotationProcessor((Class)MockitoAnnotations.Mock.class, (FieldAnnotationProcessor)new MockitoAnnotationsMockAnnotationProcessor());
        this.registerAnnotationProcessor((Class)Captor.class, (FieldAnnotationProcessor)new CaptorAnnotationProcessor());
    }

    public Object createMockFor(Annotation annotation, Field field) {
        return this.forAnnotation(annotation).process(annotation, field);
    }

    private <A extends Annotation> FieldAnnotationProcessor<A> forAnnotation(A annotation) {
        if (this.annotationProcessorMap.containsKey(annotation.annotationType())) {
            return this.annotationProcessorMap.get(annotation.annotationType());
        }
        return new FieldAnnotationProcessor<A>(){

            public Object process(A annotation, Field field) {
                return null;
            }
        };
    }

    private <A extends Annotation> void registerAnnotationProcessor(Class<A> annotationClass, FieldAnnotationProcessor<A> fieldAnnotationProcessor) {
        this.annotationProcessorMap.put(annotationClass, fieldAnnotationProcessor);
    }

    void throwIfAlreadyAssigned(Field field, boolean alreadyAssigned) {
        if (alreadyAssigned) {
            new Reporter().moreThanOneAnnotationNotAllowed(field.getName());
        }
    }
}

