/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.test.runner;

import com.google.inject.Binder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.junit.Rule;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.nuxeo.common.utils.URLStreamHandlerFactoryInstaller;
import org.nuxeo.runtime.RuntimeServiceEvent;
import org.nuxeo.runtime.RuntimeServiceListener;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentManager;
import org.nuxeo.runtime.test.NXRuntimeTestCase;
import org.nuxeo.runtime.test.runner.BlacklistComponent;
import org.nuxeo.runtime.test.runner.ConditionalIgnoreRule;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.MDCFeature;
import org.nuxeo.runtime.test.runner.RandomBug;
import org.nuxeo.runtime.test.runner.RuntimeDeployment;
import org.nuxeo.runtime.test.runner.RuntimeHarness;
import org.nuxeo.runtime.test.runner.ServiceProvider;
import org.nuxeo.runtime.test.runner.SimpleFeature;

@Features(value={MDCFeature.class, ConditionalIgnoreRule.Feature.class, RandomBug.Feature.class})
public class RuntimeFeature
extends SimpleFeature {
    protected RuntimeHarness harness;
    protected RuntimeDeployment deployment;
    protected final Map<Class<?>, ServiceProvider<?>> serviceProviders = new HashMap();

    public <T> void addServiceProvider(ServiceProvider<T> provider) {
        this.serviceProviders.put(provider.getServiceClass(), provider);
    }

    public RuntimeHarness getHarness() {
        return this.harness;
    }

    @Override
    public void initialize(FeaturesRunner runner) throws Exception {
        this.harness = new NXRuntimeTestCase(runner.getTargetTestClass());
        this.deployment = RuntimeDeployment.onTest(runner);
    }

    @Override
    public void configure(FeaturesRunner runner, Binder binder) {
        binder.bind(RuntimeHarness.class).toInstance((Object)this.getHarness());
        for (String svc : Framework.getRuntime().getComponentManager().getServices()) {
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(svc);
                ServiceProvider<?> provider = this.serviceProviders.get(clazz);
                if (provider == null) {
                    provider = new ServiceProvider(clazz);
                }
                binder.bind(clazz).toProvider(provider).in(provider.getScope());
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to bind service: " + svc, e);
            }
        }
    }

    @Override
    public void start(final FeaturesRunner runner) throws Exception {
        Framework.addListener((RuntimeServiceListener)new RuntimeServiceListener(){

            public void handleEvent(RuntimeServiceEvent event) {
                if (event.id != 0) {
                    return;
                }
                Framework.removeListener((RuntimeServiceListener)this);
                RuntimeFeature.this.blacklistComponents(runner);
            }
        });
        this.harness.start();
        this.deployment.deploy(runner, this.harness);
    }

    @Override
    public void stop(FeaturesRunner runner) throws Exception {
        this.harness.stop();
    }

    @Rule
    public MethodRule onCleanupURLStreamHandlers() {
        return new MethodRule(){

            public Statement apply(final Statement base, FrameworkMethod method, Object target) {
                return new Statement(){

                    public void evaluate() throws Throwable {
                        try {
                            base.evaluate();
                        }
                        finally {
                            URLStreamHandlerFactoryInstaller.resetURLStreamHandlers();
                        }
                    }
                };
            }
        };
    }

    @Rule
    public MethodRule onMethodDeployment() {
        return RuntimeDeployment.onMethod();
    }

    protected void blacklistComponents(FeaturesRunner aRunner) {
        BlacklistComponent config = aRunner.getConfig(BlacklistComponent.class);
        if (config.value().length == 0) {
            return;
        }
        ComponentManager manager = Framework.getRuntime().getComponentManager();
        HashSet<String> blacklist = new HashSet<String>(manager.getBlacklist());
        blacklist.addAll(Arrays.asList(config.value()));
        manager.setBlacklist(blacklist);
    }

    @Override
    public void beforeRun(FeaturesRunner runner) throws Exception {
        this.harness.fireFrameworkStarted();
    }
}

