/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.tomcat.dev;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import org.nuxeo.runtime.tomcat.dev.LocalClassLoader;

public class LocalURLClassLoader
extends URLClassLoader
implements LocalClassLoader {
    public LocalURLClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
    }

    public LocalURLClassLoader(URL[] urls, ClassLoader parent) {
        super(urls == null ? new URL[]{} : urls, parent);
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    @Override
    public synchronized Class<?> loadLocalClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(name);
        if (clazz == null) {
            clazz = this.findClass(name);
        }
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    @Override
    public URL getLocalResource(String name) {
        return this.findResource(name);
    }

    @Override
    public Enumeration<URL> getLocalResources(String name) throws IOException {
        return this.findResources(name);
    }

    @Override
    public InputStream getLocalResourceAsStream(String name) throws IOException {
        URL location = this.getLocalResource(name);
        if (location == null) {
            return null;
        }
        return location.openStream();
    }
}

